% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lorenz63-data.R
\docType{data}
\name{Lorenz63}
\alias{Lorenz63}
\title{Lorenz-1963 system}
\format{An object of class \code{list} of length 2.}
\usage{
Lorenz63
}
\description{
The Lorenz-1963 model is a three-dimensional model obtained
by Edouard N. Lorenz in 1963. The system reads
\eqn{dX/dt = -\sigma Y -\sigma Z}
\eqn{dY/dt = X (\rho - Z) - Y}
\eqn{dZ/dt = X Y - \beta Z}.
For \eqn{(\sigma, \rho, \beta) = (10,28,8/3)}, it produces a chaotic
behavior. The chaotic attractor reached at the convergence
has become paradigmatic of chaos.
Its formulation can be visualized using
visuEq(nVar = 4, dMax = 2, K = Lrz63$KL, approx = 2)
}
\references{
Lorenz, Edward Norton (1963). "Deterministic nonperiodic flow".
Journal of the Atmospheric Sciences. 20 (2): 130–141.
}
\author{
Sylvain Mangiarotti \email{sylvain.mangiarotti@cesbio.cnes.fr}
}
\keyword{data}
