% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyapFDGrond.R
\name{lyapFDGrond}
\alias{lyapFDGrond}
\title{lyapFDGrond : Computes the Lyapunov spectrum (with
compelled flow direction)}
\usage{
lyapFDGrond(outLyapFD = NULL, nVar, dMax, coeffF, intgrMthod = "rk4",
  tDeb = 0, dt, tFin, yDeb, Ddeb = NULL, nIterMin = 1,
  nIterStats = 50)
}
\arguments{
\item{outLyapFD}{List of output data that can be used
as an input in order to extend the computation}

\item{nVar}{Model dimension}

\item{dMax}{Maximum degree of the polynomial formulation}

\item{coeffF}{Model matrix. Each column correspond to
one equation. Lines provide the coefficients for each
polynomial term which order is defined with function
\code{poLabs(nVar, dMax)} in package \code{GPoM})}

\item{intgrMthod}{Numerical integration method
('rk4' by default)}

\item{tDeb}{Initial integration time (0 by default)}

\item{dt}{Integration time step}

\item{tFin}{Final integration time}

\item{yDeb}{Model initial conditions}

\item{Ddeb}{Jacobian initial conditions (optional).}

\item{nIterMin}{Minimum number of iterations (nIterMin= 1
by default)}

\item{nIterStats}{Number of iterations used in the statistics computation}
}
\value{
List of output data
}
\description{
Computes all the Lyapunov exponents based
on Gram-Schmidt procedure with zero-Lyapunov exponent compelled
to the flow direction (Grond et al. 1985).
The Jacobian matrix is computed from the original model
by semi-Formal Derivation.
}
\examples{
data(Ebola)
nVar = dim(Ebola$KL)[2]
pMax = dim(Ebola$KL)[1]
dMax = p2dMax(nVar, pMax)
outLyapFD <- NULL
outLyapFD$Grond <- lyapFDGrond(outLyapFD$Grond, nVar= nVar, dMax = dMax, coeffF = Ebola$KL, 
                               tDeb = 0, dt = 0.01, tFin = 2, yDeb = Ebola$yDeb)

}
\references{
F. Grond, H. H. Diebner, S. Sahle, A. Mathias, S. Fischer,
O. E. Rossler, A robust, locally interpretable algorithm for
Lyapunov exponents, Chaos, Solitons \& Fractals, 16, 841-852 (2003).

F. Grond \& H. H. Diebner: Local Lyapunov exponents for
dissipative continuous systems. Chaos, Solitons \& Fractals, 23,
1809-1817 (2005).
}
