% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuOutGP.R
\name{visuOutGP}
\alias{visuOutGP}
\title{visuOutGP : get a quick information of gPoMo output}
\usage{
visuOutGP(ogp, selecmod = NULL, id = 1, prioMinMax = "data",
  opt3D = "TRUE")
}
\arguments{
\item{ogp}{The output list obtained from gPoMo.}

\item{selecmod}{a vector of the model selected.}

\item{id}{the type of model to identify. id = 1 correspond to the unidentified
models, that is, potentialy chaotic models).}

\item{prioMinMax}{gives the priority for the plots among: "data", "model",
"dataonly" and "modelonly".}

\item{opt3D}{provides a 3D plot (x,y,z) when 'TRUE' (rgl library required).}
}
\value{
A Matrix describing the terms composing each model by row. The first
row corresponds to the model detection (1 unclarified, 2 diverging, 0 is fixed
point, -n with n an integer, is period-n cycle' )
}
\description{
The algorithm aims to get a quick information about
the outputs obtained with gPoMo.
}
\examples{
# load data
data("Ross76")
# # time vector
tin <- Ross76[seq(1, 3000, by = 8), 1]
# single time series
data <- Ross76[seq(1, 3000, by = 8), 3]
dev.new()
plot(tin, data, type = 'l')
# global modelling
# results are put in list outputGPoM
outputGPoM <- gPoMo(data, tin=tin, dMax = 2, nS=c(3), show = 0,
                    nPmin = 9, nPmax = 12, method = 'rk4',
                    IstepMin = 200, IstepMax = 201)
visuOutGP(outputGPoM)

}
\author{
Sylvain Mangiarotti
}

