% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipartiteBMFixedModel.R
\name{multipartiteBMFixedModel}
\alias{multipartiteBMFixedModel}
\title{Model selection and estimation of multipartite blockmodels}
\usage{
multipartiteBMFixedModel(
  list_Net,
  v_distrib,
  namesFG,
  v_K,
  classifInit = NULL,
  nbCores = NULL,
  maxiterVE = NULL,
  maxiterVEM = NULL,
  verbose = TRUE
)
}
\arguments{
\item{list_Net}{A list of network (defined via the function DefineNetwork)}

\item{v_distrib}{Type of proababilistic distributions in each network : if 0/1 then bernoulli, if counting then poisson, gaussian or Zero Inflated Gaussian (ZIgaussian) My default  = Bernoulli.
Must give a vector whose length is the number of networks in list_Net}

\item{namesFG}{Names of functional groups (must correspond to names in listNet)}

\item{v_K}{A vector with the numbers of blocks per functional group}

\item{classifInit}{A list of initial classification for each functional group in the same order as in namesFG}

\item{nbCores}{Number or cores used for the estimation. Not parallelized on windows. By default : half of the cores}

\item{maxiterVE}{Maximum number of iterations in the VE step of the VEM algorithm. Default value  = 1000}

\item{maxiterVEM}{Maximum number of iterations of the VEM algorithm. Default value  = 1000}

\item{verbose}{Set to TRUE to display the current step of the search algorithm}
}
\value{
Estimated parameters and a classification
}
\description{
Estimate the parameters and give the clustering for given numbers of blocks
}
\examples{
namesFG <- c('A','B')
list_pi <- list(c(0.5,0.5),c(0.3,0.7)) # prop of blocks in each FG
E  <-  rbind(c(1,2),c(2,2)) # architecture of the multipartite net.
typeInter <- c( "inc","diradj")
v_distrib <- c('poisson','bernoulli')
list_theta <- list()
list_theta[[1]]   <- matrix(c(6.1, 8.9, 6.6, 3), 2, 2)
list_theta[[2]] <- matrix(c(0.7,1.0, 0.4, 0.6),2, 2)
list_Net <- rMBM(v_NQ = c(20,20),E , typeInter, v_distrib, list_pi,
                list_theta, namesFG = namesFG, seed = 2)$list_Net
#res_MBMsimu_fixed <- multipartiteBMFixedModel(list_Net, v_distrib,
#                                               namesFG = namesFG,
#                                               v_K = c(1,2),
#                                               nbCores = 2)
}
