% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.stats.lsn.plot.R
\name{grin.stats.lsn.plot}
\alias{grin.stats.lsn.plot}
\title{GRIN Statistics Lesions Plot}
\usage{
grin.stats.lsn.plot(grin.res, feature = NULL, lsn.clrs = NULL, expand = 5e-04)
}
\arguments{
\item{grin.res}{GRIN results for genes or regulatory features (output of the grin.stats function)}

\item{feature}{Feature ensembl ID from Ensembl regulatory build or FANTOM5 project. An ensembl ID of a gene can be provided as well.}

\item{lsn.clrs}{Assigned colors per lesion types. If not specified, colors will be automatically assigned using default.grin.colors function.}

\item{expand}{Controls ratio of the feature locus (start and end position) to the whole plot with default value = 0.0005 (setting expand=0 will only plot the locus from the start to the end position without any of the upstream or downstream regions of the feature).}
}
\value{
Function return a plot with all types of lesions that spans either a gene or regulatory feature of interest in addition to the locus GRIN statistics without adding the transcripts panel.
}
\description{
Function return a plot with all types of lesions that spans either a gene or regulatory feature of interest with GRIN statistics added.
}
\details{
Function return a plot with all lesions that affect either a gene regulatory feature of interest. Top panel of the plot will has all different types of lesions affecting the loci color coded according to the figure legend. Lower panel of the plot has all the GRIN statistics of the feature that include number of subjects affected by each type of lesions, -log10 p, and –log10q values showing if the feature is significantly affected by the corresponding lesion category. This plot has no panel for transcripts table as regulatory features typically do not have this kind of information.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)

# run GRIN analysis
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)

# Plots showing different types of lesions and GRIN stats for a gene of interest (WT1):
grin.stats.lsn.plot(grin.results,
                     feature="ENSG00000184937")

# same function can be used to plot lesion data and GRIN statistics of regulatory features
# that typically do not have transcripts track to add to the plot.
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=grin.stats]{grin.stats()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
