% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inpaint.R
\name{inpaintImage}
\alias{inpaintImage}
\title{Use a given dictionary D to inpaint image}
\usage{
inpaintImage(I_corrupt, I_mask, D, L = 30, eps = NULL, sigma = 0,
  stepsize = 1)
}
\arguments{
\item{I_corrupt}{The image to be inpainted. In form of matrix.}

\item{I_mask}{{0,1} matrix of the same size as I_corrupt
to indicate the location of corrupted pixels.}

\item{D}{D is the dictionary used in Y=DA to inpaint.}

\item{L}{(optional) This parameter controls the maximum number of non-zero elements
in each column of sparsecolding A.}

\item{eps}{(optional) A lasso tuning paramter}

\item{sigma}{Noise level.}

\item{stepsize}{(optional) The stepsize when splicting the image. Default is 1}
}
\value{
The denoised image in for of a matrix.
}
\description{
The corrupted image is split into sqrt(m) by sqrt(m)
patches. Each patch is vectorized into a column of matrix Y.
Mask matrix M is constructed to indicate the location of missing pixels.
Using the given D, the sparse coding A_hat in Y=DA is obtained.
Then Y_inpaint=DA_hat. Then the final
inpainted image is reconstruncted.
See \url{https://arxiv.org/abs/1605.07870}
}
\examples{
I=lena_crop
## corrupt 30\% of the image
out_corrupt=AddHoles(I,0.3)
I_corrupt=out_corrupt$corruptedImage
I_mask=out_corrupt$maskImage
## use ODCT dictionary
D0=ODCT(64,100)
## inpaint
out=inpaintImage(I_corrupt,I_mask,D0)
}
