% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFilteredGenePresenceAbsenceMatrix.R
\name{makeFilteredGenePresenceAbsenceMatrix}
\alias{makeFilteredGenePresenceAbsenceMatrix}
\title{makeFilteredGenePresenceAbsenceMatrix}
\usage{
makeFilteredGenePresenceAbsenceMatrix(ref.background, geneSetCollection)
}
\arguments{
\item{ref.background}{(required) A character vector corresponding to the genes observable in a differential
expression, ATAC-Seq or other dataset. This corresponds to the background used in tools like DAVID.}

\item{geneSetCollection}{(required) A gene set collection either in the form of a tmod object, or a list of
gene sets / modules as character vectors containing gene symbols and names corresponding to the
gene module identifier.}
}
\value{
This returns a gene presence/absence matrix with genes corresponding to rows, gene sets/modules
corresponding to columns, and TRUE or FALSE values corresponding to presence or absence of a particular
gene in a particular gene set/module. This matrix has been filtered to only include genes observable in
a data set.
}
\description{
Take character vector containing the set of observable genes in a data set and a gene set
collection and generate a presence/absence matrix of observable genes in each gene set/module.
}
\examples{

library(GSNA)

# And obtain a background of observable genes from differential
# expression data:
background_genes <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Using Bai_gsc.tmod, the tmod format gene set collection in the
# sample data, we can now generate a filtered gene presence
# absence matrix. The columns of the matrix correspond to gene
# sets, whereas the rows are genes.
filteredGenePresenceAbsence_Matrix <-
          makeFilteredGenePresenceAbsenceMatrix( ref.background = background_genes,
                                                 geneSetCollection = Bai_gsc.tmod )

}
\seealso{
\code{\link{buildGeneSetNetworkLFFast}}
\code{\link{buildGeneSetNetworkSTLF}}
\code{\link{buildGeneSetNetworkJaccard}}
}
