% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gsnFilterGeneSetCollectionList}
\alias{gsnFilterGeneSetCollectionList}
\title{gsnFilterGeneSetCollectionList}
\usage{
gsnFilterGeneSetCollectionList(bg, geneSetCollection)
}
\arguments{
\item{bg}{A character vector representing gene symbols in a background of observable genes.}

\item{geneSetCollection}{A list of gene sets, in which the gene sets are character vectors containing
gene symbols, and the list names are the corresponding gene set identifiers. NOTE: This must be a list, not a
\code{tmod} object. It is trivial to extract such a list from a \code{tmod} object, however. The
\code{$MODULES2GENES} field of the \code{tmod} object contains a suitable list.}
}
\value{
A filtered gene set as a list of vectors of gene symbols in which the list names correspond to gene
set IDs.
}
\description{
Given a vector of gene symbols and a gene set collection, filter the gene set collection to include
only gene symbols present in the background.
}
\details{
This function is used in gsnORAtest_cpp to automatically filter the gene set provided. It may be used
manually during GSNA analysis.
}
\examples{

library(GSNA)

# Get the background of observable genes set from
# expression data:
gene_background <- toupper(rownames( Bai_empty_expr_mat ))

# Generate a gene set collection as a list of vectors from
# **Bai_gsc.tmod**, included in sample data:
Bai.gsc <- tmod2gsc( Bai_gsc.tmod )

# Using the sample gene set collection **Bai_gsc.tmod**,
# generate a gene set collection filtered for the bg of
# observable genes:
Bai.filt.gsc <- gsnFilterGeneSetCollectionList( bg = gene_background,
                                         geneSetCollection = Bai.gsc )

}
