% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_admixture.R
\name{simulate_admixture}
\alias{simulate_admixture}
\title{Individual based simulation of the breakdown of contiguous ancestry blocks.}
\usage{
simulate_admixture(
  module = ancestry_module(),
  pop_size = 100,
  total_runtime = 100,
  migration = migration_settings(),
  select_matrix = NA,
  multiplicative_selection = TRUE,
  verbose = FALSE,
  num_threads = 1
)
}
\arguments{
\item{module}{Chosen module to simulate, either created with
\code{module_ancestry} or
\code{module_sequence}.}

\item{pop_size}{The number of individuals in the population. If the number is
larger than the number of individuals in the input population (if provided),
additional individuals are sampled randomly from the input population to
reach the intended size.}

\item{total_runtime}{Number of generations}

\item{migration}{settings associated with migration, should be created with
\code{\link{migration_settings}}}

\item{select_matrix}{Selection matrix indicating the markers which are under
selection. If not provided by the user, the simulation proceeds neutrally. If
provided, each row in the matrix should contain five entries:
\itemize{
\item{location of the marker under selection (in Morgan) }
\item{fitness of wildtype (aa)}
\item{fitness of heterozygote (aA)}
\item{fitness of homozygote mutant (AA)}
\item{Ancestral type that represents the mutant allele A}
}}

\item{multiplicative_selection}{Default: TRUE. If TRUE, fitness is calculated
for multiple markers by multiplying fitness values for each marker. If FALSE,
fitness is calculated by adding fitness values for each marker.}

\item{verbose}{Verbose output if TRUE. Default value is FALSE}

\item{num_threads}{number of threads. Default is 1. Set to -1 to use all
available threads}
}
\value{
A list with: \code{population} a population object, and three tibbles
with allele frequencies (only contain values of a vector was provided to the
argument \code{markers}: \code{frequencies} , \code{initial_frequencies} and
\code{final_frequencies}. Each tibble contains four columns, \code{time},
\code{location}, \code{ancestor} and \code{frequency}, which indicates the
number of generations, the location along the chromosome of the marker, the
ancestral allele at that location in that generation, and finally, the
frequency of that allele.
}
\description{
Individual based simulation of the breakdown of contiguous
ancestry blocks, with or without selection. Simulations can be started from
scratch, or from a predefined input population.
}
\examples{
# local ancestry simulation
two_populations <- simulate_admixture(
                         module = ancestry_module(number_of_founders = 3,
                                                  morgan = 0.8),
                         migration = migration_settings(
                                         migration_rate = 0.01,
                                         population_size = c(100, 100)),
                         total_runtime = 10)
 # sequence simulation
 data(dgrp2.3R.5k.data)

sequence_population <-
      simulate_admixture(
                  module = sequence_module(molecular_data = dgrp2.3R.5k.data,
                           recombination_rate = 0.2,
                           mutation_rate = 1e-5),
                  pop_size = 1000,
                  total_runtime = 10)
}
