#' Example Gene Annotation in Bed-Format
#'
#' This file contains some example lines to represent a typical bed file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.bed", package="GenomicTools.fileHandler")}
#'
#' @name example.bed
#' @docType data
#' @author Daniel Fischer
#' 
#' @format A file with three column Chr, Start and End.
#'
#' @keywords data
NULL

#' Example Sequencing Reads in fasta-Format
#'
#' This file contains some example reads to represent a typical fasta file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.fasta", package="GenomicTools.fileHandler")}
#'
#' @name example.fasta
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL

#' Example Sequencing Reads in fastq-Format
#'
#' This file contains some example reads to represent a typical fastq file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.fastq", package="GenomicTools.fileHandler")}
#'
#' @name example.fastq
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL

#' Example Gene Annotation in gff-Format
#'
#' This file contains some example gene annotations to represent a typical gff file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.gff", package="GenomicTools.fileHandler")}
#'
#' @name example.gff
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL

#' Example Gene Annotation in gtf-Format
#'
#' This file contains some example gene annotations to represent a typical gtf file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.gtf", package="GenomicTools.fileHandler")}
#'
#' @name example.gtf
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL

#' Example Gene Annotation in zipped gtf-Format
#'
#' This file contains some example gene annotations to represent a typical zipped gtf file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example2.gtf.gz", package="GenomicTools.fileHandler")}
#'
#' @name example2.gtf.gz
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL


#' Example Variant data in ped/map-Format
#'
#' This file contains some example variants to represent a typical ped/map file pair that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.ped", package="GenomicTools.fileHandler")}
#'
#' @name example.ped
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL


#' Example Variant data in vcf-Format
#'
#' This file contains some example variants to represent a typical vcf file that can be used
#' to try the corresponding functions.
#' 
#' The file is locate din the /extdata folder of the package and is accessible after installation via
#' \code{system.file("extdata","example.vcf", package="GenomicTools.fileHandler")}
#'
#' @name example.vcf
#' @docType data
#' @author Daniel Fischer
#' 
#' @keywords data
NULL