% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtdd_read_TD_files.R
\name{read.TD.files}
\alias{read.TD.files}
\title{Reading excel files from Tesouro Direto}
\usage{
read.TD.files(
  dl.folder = "TD Files",
  cols.to.import = c(1, 2, 4),
  col.names = c("ref.date", "yield.bid", "price.bid")
)
}
\arguments{
\item{dl.folder}{Folder with excel files from tesouro direto}

\item{cols.to.import}{Columns (numeric) to import from excel files (open and
check the columns of the excel file from tesouro direto for details)}

\item{col.names}{Names of columns in final data.frame (same size as
cols.to.import)}
}
\value{
A dataframe with the data
}
\description{
Reads files downloaded by \code{\link{download.TD.data}}
}
\examples{
# Downloads data from tesouro direto (only 1 file for simplicity)

dl.folder ='TD Files'

\dontrun{
download.TD.data(dl.folder = dl.folder, n.dl = 1)

my.df <- read.TD.files(dl.folder = dl.folder)
}
}
