% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsCovarDistr.R
\name{pointsCovarDistr}
\alias{pointsCovarDistr}
\title{R function to plot the frequency distribution of the average value of a
spatial covariate measured at randomized locations}
\usage{
pointsCovarDistr(feature, cov.var, studyplot = NULL, B = 199, oneplot = TRUE)
}
\arguments{
\item{feature}{Feature (of point type; 'SpatialPointsDataFrame' class) representing the spatial
point pattern of interest.}

\item{cov.var}{Numeric covariate (of 'RasterLayer' class).}

\item{studyplot}{Feature (of polygon type; 'SpatialPolygonsDataFrame' class) representing the
study area and exactly matching the extent of the covariate layer. If NULL, it is worked out
from the covariate layer (may make the whole function take a while to complete).}

\item{B}{Number of randomized iterations to be used to calculate the acceptance interval (199 by
default).}

\item{oneplot}{Set to TRUE (default), will plot the charts into a single visualization.}
}
\value{
The function returns a list storing the following components: \itemize{
 \item{$obs.cov.values: }{observed values of the covariate at the point pattern locations}
 \item{$obs.average: }{average of the observed values of the covariate}
 \item{$p.value.obs.smaller.than.exp: }{p.value for the observed average smaller than expected under the Null Hypothesis}
 \item{$p.value.obs.larger.than.exp: }{p.value for the observed average larger than expected under the Null Hypothesis}
 \item{$p.value.obs.diff.from.exp: }{p.value for the observed average different from what expected under the Null Hypothesis}
}
}
\description{
The function allows to test if there is a significant dependence of the input point pattern on a
underlying numeric covariate (first-order effect).\cr The function takes as input three
datasets: a point patter ('SpatialPointsDataFrame' class), a covariate layer (of 'RasterLayer'
class), and (optionally) a polygon feature ('SpatialPolygonsDataFrame' class) representing the
study area and exactly matching the extent of the covariate layer. If the latter is not provided,
it is internally worked out from the covariate raster and may make the whole function take a
while to complete.\cr
}
\details{
The function plots a frequency distribution histogram of the average value of a spatial covariate at
randomized locations (using B iterations). At each iteration, the number of randomized points is
equal to the number of points of the input point pattern. Two blue reference lines correspond
to the 0.025th and to the 0.975th quantile of the randomized distribution.
A black dot represents the observed mean value of the covariate measured at the locations of
the input point pattern. P-values are reported. \cr
}
\examples{
#load the point dataset representing the location of springs
data(springs)

#load the polygon dataset representing the study area
data(malta_polyg)

#load the raster representing the terrain elevation, to be used as covariate
data(malta_dtm_40)

pointsCovarDistr(feature=springs, cov.var=malta_dtm_40, studyplot=malta_polyg, B=19)

}
\seealso{
\code{\link{pointsCovarModel}}, \code{\link{pointsCovarCum}}
}
\keyword{pointsCovarDistr}
