% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_scaledim}
\alias{matern_scaledim}
\alias{d_matern_scaledim}
\title{Matern covariance function, different range parameter for each dimension}
\usage{
matern_scaledim(covparms, locs)

d_matern_scaledim(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range_1, ..., range_d, smoothness, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs is a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, range_1, ..., range_d, smoothness, nugget), return the square matrix of
all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_matern_scaledim}: Derivatives with respect to parameters
}}

\section{Parameterization}{

The covariance parameter vector is (variance, range_1, ..., range_d, smoothness, nugget).
The covariance function is parameterized as
\deqn{ M(x,y) = \sigma^2 2^{1-\nu}/\Gamma(\nu) (|| D^{-1}(x - y) || )^\nu K_\nu(|| D^{-1}(x - y) || ) }
where D is a diagonal matrix with (range_1, ..., range_d) on the diagonals.
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

