% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inspect.R
\name{Inspect_test_calibrate}
\alias{Inspect_test_calibrate}
\title{Generates empirical detection threshold \eqn{\xi} for single change-point testing using Monte Carlo simulation}
\usage{
Inspect_test_calibrate(
  n,
  p,
  N = 100,
  tol = 1/100,
  lambda = NULL,
  eps = 1e-10,
  maxiter = 10000,
  rescale_variance = TRUE,
  debug = FALSE
)
}
\arguments{
\item{n}{Number of observations}

\item{p}{Number time series}

\item{N}{Number of Monte Carlo samples used}

\item{tol}{False positive probability tolerance}

\item{lambda}{Manually specified value of \eqn{\lambda} (can be \code{NULL}, in which case \eqn{\lambda \gets \sqrt{\log(p\log n)/2}})}

\item{eps}{Threshold for declaring numerical convergence of the power method}

\item{maxiter}{Maximum number of iterations for the power method}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
A list containing 
   \item{max_value}{the empirical threshold}
}
\description{
R wrapper for C function choosing the empirical detection threshold \eqn{\xi} for Inspect \insertCite{wang_high_2018;textual}{HDCD} for single change-point testing using Monte Carlo simulation.
}
\examples{
library(HDCD)
n = 50
p = 50

set.seed(100)
thresholds_emp = Inspect_test_calibrate(n,p,N=100, tol=1/100)
thresholds_emp


# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
Y = matrix(rnorm(n*p), ncol = n, nrow=p)

# Adding a single sparse change-point to X (and not Y):
X[1:5, 26:n] = X[1:5, 26:n] +2
resX = Inspect_test(X, xi = thresholds_emp$max_value)
resX
resY = Inspect_test(Y,  xi = thresholds_emp$max_value)
resY
}
\references{
\insertAllCited{}
}
