\name{correct_qqplot}
\alias{correct_qqplot}

\title{
A function to draw the quantile-quantile plot}
\description{
A function to draw the corrected quantile-quantile (Q-Q) plots, generated by 
the mixture null distribution (green dots) and by the uniform distribution 
(red dots)
}
\usage{
correct_qqplot(pmax, pnull, opt="all")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pmax}{
The vector for maximum  p-values }  
\item{pnull}{
The quantiles of p-values based on the estimated mixture null distribution
}
  \item{opt}{
Option to draw the plot. opt="all":use all the data points, 
opt="subset": use a subset of the data points, in case there 
are too many points in a genome-wide setting, to avoid overcrowded Q-Q plot.
}
}


\references{
James Y. Dai, Janet L. Stanford, Michael LeBlanc. A multiple-testing 
procedure for high-dimensional mediation hypotheses, 
Journal of the American Statistical Association, 2019, submitted. 
}
\author{
James Y. Dai and X. Wang
}

\examples{
data(exampleinputdata)
input_pvalues=snp_input
#To save time for illustration, we use 10 percent of rows
input_pvalues=input_pvalues[sample(1:nrow(input_pvalues),
size=ceiling(nrow(input_pvalues)/10)),]

pmax <- apply(input_pvalues,1,max)
nullprop <- nullestimation(input_pvalues,lambda=0.5)
pnull1 <- adjust_quantile(nullprop$alpha10,nullprop$alpha01,nullprop$alpha00,
nullprop$alpha1,nullprop$alpha2,input_pvalues,method=1)
correct_qqplot(pmax,pnull1)
}