% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD2008.TS.NABT.R
\name{SD2008.TS.NABT}
\alias{SD2008.TS.NABT}
\title{Normal-approximation-based test for two-sample problem proposed by Srivastava and Du (2008)}
\usage{
SD2008.TS.NABT(y1, y2)
}
\arguments{
\item{y1}{The data matrix (\eqn{n_1 \times p}) from the first population. Each row represents a \eqn{p}-dimensional observation.}

\item{y2}{The data matrix (\eqn{n_2 \times p}) from the second population. Each row represents a \eqn{p}-dimensional observation.}
}
\value{
A list of class \code{"NRtest"} containing the results of the hypothesis test. See the help file for \code{\link{NRtest.object}} for details.
}
\description{
Srivastava and Du (2008)'s test for testing equality of two-sample high-dimensional mean vectors with assuming that two covariance matrices are the same.
}
\details{
Suppose we have two independent high-dimensional samples:
\deqn{
\boldsymbol{y}_{i1},\ldots,\boldsymbol{y}_{in_i}, \;\operatorname{are \; i.i.d. \; with}\; \operatorname{E}(\boldsymbol{y}_{i1})=\boldsymbol{\mu}_i,\; \operatorname{Cov}(\boldsymbol{y}_{i1})=\boldsymbol{\Sigma},i=1,2.
}
The primary object is to test
\deqn{H_{0}: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2\; \operatorname{versus}\; H_{1}: \boldsymbol{\mu}_1 \neq \boldsymbol{\mu}_2.}
Srivastava and Du (2008) proposed the following test statistic:
\deqn{T_{SD} = \frac{n^{-1}n_1n_2(\bar{\boldsymbol{y}}_1 - \bar{\boldsymbol{y}}_2)^\top \boldsymbol{D}_S^{-1}(\bar{\boldsymbol{y}}_1 - \bar{\boldsymbol{y}}_2) - \frac{(n-2)p}{n-4}}{\sqrt{2 \left[\operatorname{tr}(\boldsymbol{R}^2) - \frac{p^2}{n-2}\right] c_{p, n}}},}
where \eqn{\bar{\boldsymbol{y}}_{i},i=1,2} are the sample mean vectors,  \eqn{\boldsymbol{D}_S} is the diagonal matrix of sample variance, \eqn{\boldsymbol{R}} is the sample correlation matrix and \eqn{c_{p, n}} is the adjustment coefficient proposed by Srivastava and Du (2008).
They showed that under the null hypothesis, \eqn{T_{SD}} is asymptotically normally distributed.
}
\examples{
library("HDNRA")
data("COVID19")
dim(COVID19)
group1 <- as.matrix(COVID19[c(2:19, 82:87), ]) ## healthy group
group2 <- as.matrix(COVID19[-c(1:19, 82:87), ]) ## COVID-19 patients
SD2008.TS.NABT(group1,group2)


}
\references{
\insertRef{Srivastava_2008}{HDNRA}
}
\concept{ts}
