% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools_SpecTest.R
\name{SpecTest}
\alias{SpecTest}
\title{Statistical inference for high-dimensional spectral density matrix}
\usage{
SpecTest(X, J.set, cross.indices, B = 1000, flag_c = 0.8)
}
\arguments{
\item{X}{\eqn{{\bf X} = \{{\bf x_1}, \dots , {\bf x}_n \}}, a \eqn{n\times
p} sample matrix, where \eqn{n} is the sample size and \eqn{p} is the 
dimension of \eqn{{\bf x}_t}.}

\item{J.set}{Set \eqn{\mathcal{J}} for frequencies, a vector, used to calculate the test statistic.}

\item{cross.indices}{Set \eqn{\mathcal{I}} for \eqn{(i,j)}, a matrix with 2 columns,
used to calculate the test statistic.}

\item{B}{Bootstrap times for generating multivariate normal distributed 
random vectors in calculating the critical value. Default is \code{B} \eqn{=2000}.}

\item{flag_c}{Bandwidth \eqn{c} of the flat-top kernel for estimating 
\eqn{f_{i,j}(\omega)}, where \eqn{c\in(0,1]}. Default is \code{flag_c} \eqn{=0.8}.}
}
\value{
An object of class "hdtstest" is a list containing the following
  components:

  \item{Stat}{Numerical value which represents the value of test statistic.}
  \item{pval}{Numerical value which represents the p-value of the test.}
  \item{cri95}{Numerical value which represents the critical value of the test
  at the significance level 0.05.}
  \item{method}{A character string indicating what method was performed.}
}
\description{
\code{SpecTest()} implements a new global test proposed in
 Chang, Jiang, McElroy and Shao (2023) for the following hypothesis testing problem: 
\deqn{H_0:f_{i,j}(\omega)=0 \mathrm{\ for\ any\ }(i,j)\in\mathcal{I}\mathrm{\ and\ }
\omega \in \mathcal{J}\mathrm{\ \ versus\ \ H_1:H_0\ is\ not\ true.} }
}
\examples{
n <- 200
p <- 10
flag_c <- 0.8
B <- 1000
burn <- 1000
z.sim <- matrix(rnorm((n+burn)*p),p,n+burn)
phi.mat <- 0.4*diag(p)
x.sim <- phi.mat \%*\% z.sim[,(burn+1):(burn+n)]
x <- x.sim - rowMeans(x.sim)
cross.indices <- matrix(c(1,2), ncol=2)
J.set <- 2*pi*seq(0,3)/4 - pi
res <- SpecTest(t(x), J.set, cross.indices, B, flag_c)
Stat <- res$Stat
Pvalue <- res$p.value
CriVal <- res$cri95
}
\references{
Chang, J., Jiang, Q., McElroy, T. & Shao, X. (2023). 
\emph{Statistical inference for high-dimensional spectral density matrix}.
}
