% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readHFD.R
\name{readHFCweb}
\alias{readHFCweb}
\title{readHFCweb get HFC data straight from the web into R!}
\usage{
readHFCweb(CNTRY, item, fixup = TRUE, ...)
}
\arguments{
\item{CNTRY}{character string of the HCD short code. Only one! Run \code{getHFCcountries(FALSE)} to see what the options are.}

\item{item}{character string of the data product code, which is the base file name, but excluding the country code and file extension \code{.txt}. For instance, \code{"ASFRstand_TOT"}, \code{"ASFRstand_BO"}, \code{"TFRMAB_TOT"}, \code{"TFRMAB_BO"}. Only one item!}

\item{fixup}{logical. Default \code{TRUE}. Should column classes be coerced to those more similar to HFD, HMD?}

\item{...}{optional arguments passed to \code{read.csv()}. Not required.}
}
\description{
This concatenates the necessary url and calls \code{read.csv()} with all the necessary defaults to avoid annoying surprises. \code{Age} is given as an integer, along with an \code{AgeInterval}. The default behavior is to change the \code{AgeInterval} column to character and produce a logical indicator column, \code{OpenInterval}. \code{Year} is also given as the starting year of a \code{YearInterval}, rather than the original \code{Year1} and \code{Year2} columns. The column \code{Country} is renamed \code{CNTRY}. All other original columns are maintained. Output is invisibly returned, so you must assign it to take a look.
}
\examples{
\dontrun{
DF <- readHFCweb("CZE","TFRMAB_TOT")
head(DF)
DF <- readHFCweb("CZE","ASFRstand_BO")
head(DF)

# get ASFRstand_BO for all countries where available:
Countries <- getHFCcountries()
# takes a minute to run
# require(RCurl)
HaveBO <- sapply(Countries, function(CNTRY, item){
            RCurl::url.exists(paste0("http://www.fertilitydata.org/data/",
CNTRY,"/", CNTRY, "_", item, ".txt"))
        }, item = "ASFRstand_BO")
# we grab data for these countries:
(Countries <- Countries[HaveBO])

# Also takes 1-15 min depending on internet connection and machine
# read in one at a time and stick together into long data.frame
allBO <- do.call(rbind,
        # this is the iteration of reading in
        lapply(Countries, function(CNTRY){
            readHFCweb(CNTRY, item = "ASFRstand_BO")
             })) # closes off the meta-rbind thingy
dim(allBO) # [1] 133237     31
unique(allBO$CNTRY)

}
}

