% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm.filter.R
\name{hmm.filter}
\alias{hmm.filter}
\title{HMM filter functions}
\usage{
hmm.filter(g, L, K1, K2, P, maskL = T, bound.thr = 0.1, minBounds = 10)
}
\arguments{
\item{g}{grid from \code{\link{setup.grid}}}

\item{L}{is likelihood array output from \code{make.L}}

\item{K1}{first movement (diffusion) kernel see \code{\link{gausskern}}}

\item{K2}{second movement (diffusion) kernel see \code{\link{gausskern}}}

\item{P}{2x2 probability matrix for transitions between states (K1 and K2)}

\item{maskL}{is logical indicating whether to mask the input L layer. See
\code{mask.L} for details.}

\item{bound.thr}{is numeric indicating the percent threshold that is added 
and subtracted from the bounding box of the filter output from the 
previous day before masking. Default is .05 (5 percent).}

\item{minBounds}{is size (in degrees) of the minimum bounding box around the 
previous days filter prediction that L data within that box will be 
included. Outside this box (centered on t-1 filter prediction), L will be 
masked out.}
}
\value{
a list: list(phi = phi, pred = pred, psi = psi) where \itemize{ \item
  phi. is the probability for each state at each time step \item pred. is
  .... \item psi. is.... }
}
\description{
HMM filter functions
}
\examples{
\dontrun{
# Not run as function relies on large arrays of likelihoods
# RUN THE FILTER STEP
f <- hmm.filter(g, L, K1, K2, maskL=T, P.final, minBounds = bnd)
nllf <- -sum(log(f$psi[f$psi>0])) # negative log-likelihood

}

}
\references{
Pedersen MW, Patterson TA, Thygesen UH, Madsen H (2011)
  Estimating animal behavior and residency from movement data. Oikos
  120:1281-1290. doi: 10.1111/j.1600-0706.2011.19044.x
}
