\name{Lanza}
\alias{Lanza}
\docType{data}
\title{ Prevention of Gastointestinal Damages }
\description{
  Data from four randomised clinical trials on the prevention of 
  gastointestinal damages by Misoprostol reported by Lanza et al.
  (1987, 1988a,b, 1989).
}
\usage{data("Lanza")}
\format{
  A data frame with 198 observations on the following 3 variables.
  \describe{
    \item{\code{study}}{a factor with levels \code{I}, \code{II},
                        \code{III}, and \code{IV} describing the study number.}
    \item{\code{treatment}}{a factor with levels \code{Misoprostol} \code{Placebo}}
    \item{\code{classification}}{an ordered factor with levels \code{1} < \code{2} < \code{3} < \code{4} < \code{5}
                                 describing an ordered response variable.}
  }
}
\details{

    The response variable is defined by the number of haemorrhages or
    erosions. 

}
\source{

    F. L. Lanza (1987), A double-blind study of prophylactic effect of misoprostol on
    lesions of gastric and duodenal mucosa induced by oral administration of tolmetin 
    in healthy subjects. \emph{British Journal of Clinical Practice}, May
    suppl, 91--101.

    F. L. Lanza, R. L. Aspinall, E. A. Swabb, R. E. Davis, M. F. Rack, A. Rubin
    (1988a), Double-blind, placebo-controlled endoscopic comparison of the
    mucosal protective effects of misoprostol versus cimetidine on
    tolmetin-induced mucosal injury to the stomach and duodenum. 
    \emph{Gastroenterology}, \bold{95}(2), 289--294.

    F. L. Lanza, K. Peace, L. Gustitus, M. F. Rack, B. Dickson (1988b),
    A blinded endoscopic comparative study of misoprostol versus
    sucralfate and placebo in the prevention of aspirin-induced
    gastric and duodenal ulceration. \emph{American Journal of Gastroenterology},
    \bold{83}(2), 143--146.

    F. L. Lanza, D. Fakouhi, A. Rubin, R. E. Davis, M. F. Rack, C. Nissen, S. Geis
    (1989), A double-blind placebo-controlled comparison of the efficacy
    and safety of 50, 100, and 200 micrograms of misoprostol
    QID in the prevention of ibuprofen-induced gastric and
    duodenal mucosal lesions and symptoms. \emph{American Journal of  Gastroenterology},
    \bold{84}(6), 633--636.

}
\examples{

  data("Lanza", package = "HSAUR")
  layout(matrix(1:4, nrow = 2))
  pl <- tapply(1:nrow(Lanza), Lanza$study, function(indx)
      mosaicplot(table(Lanza[indx,"treatment"], 
                       Lanza[indx,"classification"]),
                 main = "", shade = TRUE))

}
\keyword{datasets}
