% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WriteInfo}
\alias{WriteInfo}
\title{Write a 'info.txt' File}
\usage{
WriteInfo(x, filename)
}
\arguments{
\item{x}{The object to be written, a list with named vector elements, as an object returned from \code{\link{ReadInfo}} using the \code{exact} mode.}

\item{filename}{A character string naming a file to write to. Windows users: Note that
Paths are separated by '/', not '\\'.}
}
\value{
No return value, called for export to text files.
}
\description{
\code{WriteInfo} writes its required argument \code{x} to a file.
}
\details{
\code{WriteInfo} writes an 'info.txt' file, typically originating from an imported and modified 'info.txt'.
}
\examples{
te <- ReadInfo(filename = system.file("demo_model",
"info.txt", package = "HYPEtools"), mode = "exact")
WriteInfo(x = te, filename = tempfile())


}
\seealso{
\code{\link{ReadInfo}} with a description of the expected content of \code{x}.
\code{\link{AddInfoLine}}
\code{\link{RemoveInfoLine}}
}
