% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate.packages.R
\name{duplicate.packages}
\alias{duplicate.packages}
\title{List the duplicated packages with their locations}
\usage{
duplicate.packages()
}
\value{
A data.frame with 4 elements for each duplicated packages:\cr
- versions: the version of the packages\cr
- libraries: the locations\cr
}
\description{
A data.frame with the duplicated packages and their locations and version.\cr
The columns Lib1 and Version1 should have the oldest version of the packages. Then 
you can try:\cr
li <- duplicate.packages()
if (nrow(li) != 0) {
    for (i in 1:nrow(li))
        remove.packages(rownames(li)[i], lib=li[i, "Lib1"])
}
}
\details{
duplicate.packages lists the duplicated packages with their locations
}
\examples{
\dontrun{
library(HelpersMG)
duplicate.packages()
}
}
\author{
Marc Girondot
}
