% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{ellipse}
\alias{ellipse}
\title{Plot an ellipse}
\usage{
ellipse(center.x = 0, center.y = 0, radius.x = 1, radius.y = 1,
  radius.x.lower = NULL, radius.x.upper = NULL,
  radius.y.lower = NULL, radius.y.upper = NULL, alpha = 0,
  binconf.x = NULL, binconf.y = NULL, control.binconf = list(alpha =
  0.05, method = "wilson"), length = 100, ...)
}
\arguments{
\item{center.x}{Center of the ellipse on x axis}

\item{center.y}{Center of the ellipse on y axis}

\item{radius.x}{Radius along the x axis}

\item{radius.y}{Radius along the y axis}

\item{radius.x.lower}{Radius along the x axis, at left of center}

\item{radius.x.upper}{Radius along the x axis, at right of center}

\item{radius.y.lower}{Radius along the y axis, at bottom of center}

\item{radius.y.upper}{Radius along the y axis, at top of center}

\item{alpha}{Rotation in radians}

\item{binconf.x}{A data.frame or a matrix with two columns, x and n or with three columns, PointEst, Lower, and Upper}

\item{binconf.y}{A data.frame or a matrix with two columns, x and n or with three columns, PointEst, Lower, and Upper}

\item{control.binconf}{A list with options for binomial confidence}

\item{length}{Number of points to draw the ellipse}

\item{...}{Graphical parameters}
}
\value{
Nothing
}
\description{
Plot a ellipse dined by the center and the radius. The options for 
binomial confidence are:\cr
- alpha is 1 - confidence interval\cr
- method  must be one of these "wilson", "exact", "asymptotic"\cr
col parameter can be a list of colors. See examples
}
\details{
ellipse plots an ellipse
}
\examples{
plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", las=1, bty="n", 
     xlab="Variable x", ylab="variable y")
 
ellipse(center.x = c(0.2, 0.3, 0.25), center.y = c(0.7, 0.6, 0.55), 
        radius.x = c(0.1, 0.1, 0.1), radius.y = c(0.15, 0.2, 0.4), 
        border=NA, col=rgb(red = 0.1, green = 0.1, blue = 0.1, alpha = 0.1))

ellipse(center.x = 0.5, center.y = 0.5, 
        radius.x.lower = 0.1, radius.x.upper = 0.3, 
        radius.y = 0.2, 
        border=NA, col=rgb(red = 0.1, green = 0.1, blue = 0.1, alpha = 0.1))

ellipse(center.x = 0.6, center.y = 0.3, 
        radius.x.lower = 0.3, radius.x.upper = 0.3, 
        radius.y.lower = 0.2, radius.y.upper = 0.4, 
        border=NA, col=rgb(red = 0.1, green = 0.1, blue = 0.1, alpha = 0.1))

plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", bty="n", asp=1, 
     xlab="Variable x", ylab="variable y", axes=FALSE)
axis(1, at=c(0, 0.25, 0.5, 0.75, 1))
axis(2, at=c(0, 0.25, 0.5, 0.75, 1), las=1)

ellipse(center.x = 0.5, center.y = 0.5, radius.x = 0.2, radius.y = 0.4, 
       border=NA, col=rgb(red = 0.1, green = 0.1, blue = 0.1, alpha = 0.1))
ellipse(center.x = 0.5, center.y = 0.5, radius.x = 0.2, radius.y = 0.4, 
        border=NA, col=rgb(red = 0.1, green = 0.1, blue = 0.1, alpha = 0.1), alpha = pi/4)

plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", las=1, bty="n", 
     xlab="Variable x", ylab="variable y")

for (k in 0:8)
  ellipse(center.x=0.5, center.y=0.5, radius.x=0.1, radius.y=0.4, 
          alpha=seq(from=0, to=pi/4, length=9)[k], 
          border=rainbow(9)[k])

# Exemple with confidence of proportions
males <- c(10, 25, 3, 4)
N <- c(12, 52, 17, 10)

males2 <- c(12, 20, 3, 6)
N2 <- c(15, 50, 20, 12)

plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", las=1, bty="n", 
     xlab="Variable x", ylab="variable y")

ellipse(binconf.x = data.frame(x=males, n=N), binconf.y = data.frame(x=males2, n=N2),  
        border=NA, col=rgb(red = 0.1, green = 0.5, blue = 0.1, alpha = 0.1))
        
plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", las=1, bty="n", 
     xlab="Variable x", ylab="variable y")
     
ellipse(binconf.x = data.frame(x=males, n=N), 
        binconf.y = data.frame(PointEst=c(0.1, 0.2, 0.3, 0.5), 
                               Lower=c(0.02, 0.12, 0.25, 0.30), 
                               Upper=c(0.18, 0.29, 0.35, 0.67)), 
        border=NA, col=rgb(red = 0.1, green = 0.5, blue = 0.1, alpha = 0.1))
        
# Examples with a gradient
plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", las=1, bty="n", 
     xlab="Variable x", ylab="variable y")
ellipse(center.x = 0.6, center.y = 0.3, 
        radius.x.lower = 0.3, radius.x.upper = 0.3, 
        radius.y.lower = 0.2, radius.y.upper = 0.4, 
        border=NA, col=grey.colors(100, alpha = 0.1))
        
plot(0:1, 0:1, xlim=c(0, 1), ylim=c(0,1), lty=2, type="l", las=1, bty="n", 
     xlab="Variable x", ylab="variable y")
ellipse(binconf.x = data.frame(x=males, n=N), binconf.y = data.frame(x=males2, n=N2),  
        border=NA, col=grey.colors(100, alpha = 0.1))

}
\author{
marc.girondot@u-psud.fr
}
