% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{fit.CP}
\alias{fit.CP}
\title{Fit compound Poisson mixed effect models (CPMM) for one or more features.}
\usage{
fit.CP(CountMatrix, Strains, test = FALSE, optimizer = "nlminb")
}
\arguments{
\item{CountMatrix}{Sequencing count matrix for one or more features. Each 
row is for one feature, and the columns are for samples.}

\item{Strains}{Strain labels for the samples.}

\item{test}{TRUE or FALSE (default). Test the presence of heritability 
through examining the random effect variance \eqn{\sigma_g^2 = 0}{}.}

\item{optimizer}{A character string that determines which optimization 
routine is to be used. Possible choices are "nlminb" (default), 
"L-BFGS-B", and "bobyqa".}
}
\value{
A list with two objects. The first object is a 
\eqn{G \times 4}{G x 4} matrix indicating the fitted parameters for each 
feature. The columns are ordered by intercept \eqn{\alpha_g}, tweedie 
parameter \eqn{p_g}, random effect variance \eqn{\sigma^2_g}, and dispersion
\eqn{\phi_g}. Row names are feature names. If the argument test is set to
be true, the second object of the list consists of p-values for testing 
the hypothesis that random effects \eqn{\sigma_a^2 = 0}{sigma_a2 = 0}; 
otherwise, the second object is NULL.
}
\description{
Fit a CPMM for one or more features and output the fit parameters. 
It is used before the function computeVPC.CP(). This function also allows 
to test the presence of heritability via random effect variance of the model.
}
\examples{
## Fit CPMM for the first two features and test the presence of 
## heritability. 
result.cp <- fit.CP(simData[1:2, ], strains, test = TRUE)
## Extract parameters
para.cp <- result.cp[[1]]
## Extract p-values
pval.cp <- result.cp[[2]]

}
