% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{dotpW}
\alias{dotpW}
\alias{dotpW,distributionH,distributionH-method}
\alias{dotpW,distributionH,numeric-method}
\alias{dotpW,distributionH-method}
\alias{dotpW,numeric,distributionH-method}
\title{Method \code{dotpW}}
\usage{
dotpW(e1, e2)

\S4method{dotpW}{distributionH,distributionH}(e1, e2)

\S4method{dotpW}{numeric,distributionH}(e1, e2)

\S4method{dotpW}{distributionH,numeric}(e1, e2)
}
\arguments{
\item{e1}{a \code{distributionH} object or a number}

\item{e2}{a \code{distributionH} object or a number}
}
\value{
A numeric value
}
\description{
Method \code{dotpW}

The dot product of two distributions inducing the L2 Wasserstein metric

The dot product of a number (considered as an impulse distribution function) and a distribution

The dot product of a distribution and a number (considered as an impulse distribution function).
}
\examples{

## let's define two distributionH objects
mydist1<-distributionH(x=c(1,2,3,10), p=c(0,0.1,0.5,1))
mydist2<-distributionH(x=c(5,7,15), p=c(0,0.7,1))

## the dot product between the distributions
dotpW(mydist1,mydist2) #---> 39.51429

## the dot product between a distribution and a numeric
dotpW(mydist1,3)  #---> 13.2
dotpW(3,mydist1)  #---> 13.2


}
\author{
Antonio Irpino
}
\references{
Irpino, A., Verde, R. (2015) \emph{Basic
statistics for distributional symbolic variables: a new metric-based
approach} Advances in Data Analysis and Classification, DOI 10.1007/s11634-014-0176-4
}
\keyword{distribution}

