## HoRM: Supplemental Functions and Datasets for "Handbook of Regression Methods"	<a href='https://github.com/dsy109/HoRM'><img src='man/figures/HoRM.png' align="right" height="138.5" /></a>

[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)	
![CRAN/METACRAN](https://img.shields.io/cran/l/HoRM)	
[![CRAN status](https://www.r-pkg.org/badges/version/HoRM)](https://CRAN.R-project.org/package=HoRM)
[![Dependencies](https://tinyverse.netlify.com/badge/HoRM)](https://cran.r-project.org/package=HoRM)
![GitHub last commit](https://img.shields.io/github/last-commit/dsy109/HoRM)
[![Downloads](https://cranlogs.r-pkg.org/badges/HoRM?color=brightgreen)](https://www.r-pkg.org/pkg/HoRM)
[![Shiny](https://img.shields.io/badge/Shiny-HoRM-brightgreen)](https://horm.as.uky.edu/)
[![Book](https://img.shields.io/badge/HoRM__Book-ISBN%209781498775298-brightgreen)](https://www.routledge.com/Handbook-of-Regression-Methods/Young/p/book/9781498775298)

### Synopsis

The [HoRM package](https://cran.r-project.org/package=HoRM) provides supplemental functions and datasets for the book [_Handbook of Regression Methods_](https://www.routledge.com/Handbook-of-Regression-Methods/Young/p/book/9781498775298) by [Derek S. Young](https://young.as.uky.edu/).  Illustrations of the datasets are included in both that textbook as well as the accompanying [Shiny app](https://horm.as.uky.edu/).

Other highlights:

- Includes 21 real datasets, each of which is analyzed in the book _Handbook of Regression Methods_.

- Inclcudes some original functions, such as for the regressogram and power functions for the general linear F-test.

### Documentation

The book _Handbook of Regression Methods_ provides documentation about the HoRM package.  Moreover, the [help file](https://CRAN.R-project.org/package=HoRM) also documents the original sources for each dataset.

### Examples

All examples in _Handbook of Regression Methods_ are demonstrated in the [Shiny app](https://horm.as.uky.edu/).

### Installation

Released and tested versions of Rcpp are available via the
[CRAN](https://cran.r-project.org) network, and can be installed from within R via

```R
install.packages("HoRM")
```

### Support

The [issue tickets at the GitHub repo](https://github.com/dsy109/HoRM/issues)
are the primary bug reporting interface.  As with the other web resources,
previous issues can be searched as well.

### Authors

Derek S.  Young

### License

GPL (>= 2)

### Code of Conduct

As contributors and maintainers of this project, we pledge to respect all people who 
contribute through reporting issues, posting feature requests, updating documentation, 
submitting pull requests or patches, and other activities.  Both contributors and 
maintainers must consistently demonstrate acceptable behavior, respectful communications, 
and professional conduct.  Project maintainers have the right and responsibility to remove, 
edit, or reject comments, commits, code, wiki edits, issues, and other contributions that 
are not aligned to this Code of Conduct.  Project maintainers who do not follow the 
Code of Conduct may be removed from the project team.  Instances of abusive, harassing, 
or otherwise unacceptable behavior may be reported by opening an issue or contacting one 
or more of the project maintainers.  By contributing to this project, you agree to abide 
by its terms.

We are here for a love of coding and a passion for cultivating knowledge.  Let us enjoy 
this collaboration together!



