% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatTable.R
\name{satTabhT}
\alias{satTabhT}
\title{Table of Saturation Liquid Phase Enthalpies, Function of Temperature}
\usage{
satTabhT(T1, T2, dT)
}
\arguments{
\item{T1}{Initial Temperature [K]}

\item{T2}{Final Temperature [K]}

\item{dT}{Temperature increment [K]}
}
\value{
A table of saturation fluid enthalpies, function of T
}
\description{
The function \code{satTabhT(T1, T2, dT)} returns a table of 
    saturation liquid enthalpies [kJ kg-1 K-1] for a Temperature interval, T1:T2 [K]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T1 <- 275.
T2 <- 450.
dT <- 5.
satTabhT(T1, T2, dT)

T1 <- 300.
T2 <- 500.
dT <- 10.
TabT <- satTabhT(T1, T2, dT)

}

