% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadAndSplitMutectVCFs}
\alias{ReadAndSplitMutectVCFs}
\title{Read and split Mutect VCF files.}
\usage{
ReadAndSplitMutectVCFs(files, names.of.VCFs = NULL,
  tumor.col.names = NA)
}
\arguments{
\item{files}{Character vector of file paths to the Mutect VCF files.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order of
names in \code{names.of.VCFs} should match the order of VCF file paths in
\code{files}. If \code{NULL}(default), this function will remove all of the
path up to and including the last path separator (if any) in \code{files}
and file paths without extensions (and the leading dot) will be used as the
names of the VCF files.}

\item{tumor.col.names}{Character vector of column names in VCFs which contain
the tumor sample information. The order of names in \code{tumor.col.names}
should match the order of VCFs specified in \code{files}. If
\code{tumor.col.names} is equal to \code{NA}(default), this function will
use the 10th column in all the VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}
}
\value{
A list with 3 in-memory VCFs and two left-over
VCF-like data frames with rows that were not incorporated
into the first 3 VCFs, as follows:

\enumerate{

 \item \code{SBS} VCF with only single base substitutions.

 \item \code{DBS} VCF with only doublet base substitutions
  as called by Mutect.

 \item \code{ID} VCF with only small insertions and deletions.

 \item \code{other.subs} VCF like data.frame with
 rows for coordinate substitutions involving
 3 or more nucleotides, e.g. ACT > TGA or AACT > GGTA.

 \item \code{multiple.alternative.alleles} VCF like data.frame with
 rows for variants with multiple alternative alleles, for example
 ACT mutated to both AGT and ACT at the same position.

}
}
\description{
Read and split Mutect VCF files.
}
\examples{
file <- c(system.file("extdata",
                      "Mutect.GRCh37.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitMutectVCFs(file)
}
\seealso{
\code{\link{MutectVCFFilesToCatalog}}
}
