% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CatalogRowOrder}
\alias{CatalogRowOrder}
\alias{catalog.row.order}
\title{Standard order of row names in a catalog}
\format{
A list of character vectors indicating the standard
  orders of row names in catalogs.

An object of class \code{list} of length 8.
}
\usage{
catalog.row.order
}
\description{
This data is designed for those
who need to create their own catalogs from formats not
supported by this package. The rownames denote the mutation
types.  For example, for SBS96 catalogs, the rowname
 AGAT represents a mutation from AGA > ATA.
}
\note{
In ID (small insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation deletion
  repeat sizes range from 1 to 6+. In ID83 catalogs, deletion repeat sizes
  range from 0 to 5.
}
\section{ID classification}{

See \url{https://github.com/steverozen/ICAMS/blob/master/data-raw/PCAWG7_indel_classification_2021_09_03.xlsx}
for additional information on ID (small insertion and deletion) mutation
classification.

See the documentation for \code{\link{Canonicalize1Del}} which first handles
deletions in homopolymers, then handles deletions in simple repeats with
longer repeat units, (e.g. \code{CACACACA}, see
\code{\link{FindMaxRepeatDel}}), and if the deletion is not in a simple
repeat, looks for microhomology (see \code{\link{FindDelMH}}).

See the code for unexported function \code{\link{CanonicalizeID}}
and the functions it calls for handling of insertions.
}

\examples{
catalog.row.order$SBS96
# "ACAA" "ACCA" "ACGA" "ACTA" "CCAA" "CCCA" "CCGA" "CCTA" ...
# There are altogether 96 row names to denote the mutation types
# in SBS96 catalog.
}
\keyword{datasets}
