% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_icd_labels}
\alias{get_icd_labels}
\title{Returns a data frame with ICD metadata, consisting of
year, ICD code and label. Optional arguments allow selection of
entries by year, code or label. This is beneficial because the
entire history is relatively large and rarely required in full.}
\usage{
get_icd_labels(year = NULL, icd3 = NULL, search = NULL, ...)
}
\arguments{
\item{year}{Year or years to get (numeric or character vector)}

\item{icd3}{A character vector of three-digit ICD-10 codes to select}

\item{search}{(optional) A string to search for in the label column using fuzzy matching (agrep)}

\item{...}{(optional) Further arguments passed to agrep when searching with icd_label}
}
\value{
data.frame(year, icd3, icd_code, icd_normcode, icd_sub, label), see icd_labels
}
\description{
Returns a data frame with ICD metadata, consisting of
year, ICD code and label. Optional arguments allow selection of
entries by year, code or label. This is beneficial because the
entire history is relatively large and rarely required in full.
}
\examples{
get_icd_labels(year = 2019, icd3 = "I25")
get_icd_labels(year = 2019, search = "Asthma")
}
