% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODSDesignIC.R
\name{ODSDesignIC}
\alias{ODSDesignIC}
\title{Outcome-Dependent Sampling with Interval-Censored Failure Time Data}
\usage{
ODSDesignIC(U, V, del1, del2, z, mVal, ind, a1, a2, beta = NULL,
  maxit = 10L, verbose = TRUE, ...)
}
\arguments{
\item{U}{numeric vector (n); examination time. 
See Details for further information.}

\item{V}{numeric vector (n); examination time.
See Details for further information.}

\item{del1}{integer vector (n); indicator of a left-censored observation I(T<=U).
See Details for further information.}

\item{del2}{integer vector (n); indicator of an interval-censored observation I(U<T<=V).
See Details for further information.}

\item{z}{matrix (nxp); covariates.}

\item{mVal}{integer vector (m); one or more options for the degree of 
the Bernstein polynomials. If more than one option provided, the value 
resulting in the lowest
AIC is selected. The results returned are for only that m-value.}

\item{ind}{integer vector (n); indicating membership of the simple random 
sample (0), lower-tail supplemental sample (1), or upper-tail 
supplemental sample (2).}

\item{a1}{numeric (1); lower cut-off point for selecting ODS sample 
(0 < a1 < a2 < tau).}

\item{a2}{numeric (1); upper cut-off point for selecting ODS sample 
(0 < a1 < a2 < tau).}

\item{beta}{numeric vector (p); initial values for beta. If NULL, initial
guess set to 0.5 for each of the p parameters.}

\item{maxit}{integer(1); maximum number of calls to optimization method.}

\item{verbose}{logical; TRUE generates progress screen prints.}

\item{...}{optional inputs to "control" of function optim().}
}
\value{
an object of class ODSDesign (inheriting from ICODS) containing
\item{optim}{a list of the results returned by optim().}
\item{beta}{the estimated beta parameters.}
\item{se}{the standard error of the estimated beta parameters.}
\item{pValue}{the p-value of the estimated beta parameters.}
\item{m}{the selected degree of the Bernstein polynomials.}
\item{AIC}{the AIC value for the selected degree of the Bernstein polynomials.}
}
\description{
Provides an outcome-dependent sampling (ODS) design with interval-censored
  failure time data, where the observed sample is enriched by selectively 
  including certain more informative failure subjects. The method is a 
  sieve semiparametric maximum empirical likelihood approach for 
  fitting the proportional hazards model to data from the interval-
  censoring ODS design.
}
\details{
The implementation uses stats::optim() to minimize the likelihood. The
  hard-coded method is "BFGS". Users are able to make changes to the
  'control' input of optim() by passing named inputs through the ellipses.
  If a call to optim() returns convergence = 1, i.e., optim() reached its
  internal maximum number of iterations before convergence was attained,
  the software automatically repeats the call to optim() with input 
  variable par set to the last parameter values. This procedure is 
  repeated at most maxit times.

Input parameters U, V, del1, and del2 are defined as follows. 
  Suppose there are 
  K follow-up examinations at times TE = (T1, T2, ..., TK), and the failure
  time is denoted as TF. 
  For left-censored data, the failure occurred prior to the first 
  follow-up examination (TF < T1); therefore, define U = T1, V = tau, and 
  (del1,del2)=(1,0). For right-censored data, the
  failure had not yet occurred at the last follow-up examination 
  (TF > TK); therefore, define U = 0, V = TK, 
  and (del1,del2)=(0,0). For interval-censored data, the failure occurred
  between two follow-up examinations, e.g. T2 < TF < T3; therefore, 
  define U and V to be the two consecutive follow-up examination times 
  bracketing the failure time TF and (del1,del2)=(0,1).
}
\examples{

data(odsData)

result <- ODSDesignIC(U = odsData$U, 
                      V = odsData$V,  
                      del1 = odsData$del1,  
                      del2 = odsData$del2, 
                      z = odsData$z, 
                      mVal = 1L, 
                      ind = odsData$ind, 
                      a1 = 0.43, 
                      a2 = 0.45, 
                      beta = NULL, 
                      maxit = 10L,
                      verbose = TRUE)

print(result)
mVal(result)
estimate(result)
optimObj(result)
minAIC(result)
summary(result)

}
\references{
Zhou, Q., Cai, J., and Zhou, H. (2018). Outcome-dependent 
  sampling with interval-censored failure time data. Biometrics, 
  74(1): 58--67.  <doi:10.1111/biom.12744>
}
