% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_idea.R
\encoding{UTF-8}
\name{plot_idea}
\alias{plot_idea}
\title{Plot IDEA4 results}
\usage{
plot_idea(IDEA_data, choices = c("dimensions", "trees", "radars"))
}
\arguments{
\item{IDEA_data}{an IDEA_data or IDEA_group_data object}

\item{choices}{Which type of plots should be produced ? Can be either "dimensions", "trees" or "radars" or a combination of these 3. Ignored if IDEA_data is of class \code{IDEA_group_data}.}
}
\value{
a named list of plots of class \code{IDEA_plots} or \code{IDEA_group_plots}. The algorithm also adds a "data" attribute containing data introduced in the input of this function.
}
\description{
Produces ggplots and/or SVG source code with IDEA data produced by either \code{compute_idea()} or \code{old_idea()} call.
}
\details{
This function will produce different plots depending on whether the input data is of class \code{IDEA_data} or \code{IDEA_group_data}.

The \code{IDEA_data} class implies that the data comes from an individual analysis pipeline, so individual plots will be produced according to the user's choices specified in the function call :

\describe{
\item{dimensions}{This option will produce histograms for dimensions, components, and indicators along with a polarised synthetic representation for components.}
\item{trees}{This option will produce the colored trees describing the qualitative agregation in the property approach.}
\item{radars}{This option will produce polarised histograms (also called 'radars') giving the score (in \%) of each indicator, grouped by property}
}

Important note : All 3 types of plots are required for the "report" option of the \code{write_idea()} function.

The \code{IDEA_group_data} class can only be generated by a "\code{diag_idea()}" group call which will iterate either "\code{read_idea() |> compute_idea()}" or "\code{old_idea()}" on each data file before aggregating results and assigning this grouped class.

As the \code{IDEA_group_data} class implies that the data comes from a group analysis pipeline, the \code{choices} argument will be ignored. The plots produced for the dimension approach are almost the same as in the individual analysis pipeline but with the histograms being replaced by boxplots. Concerning properties, the only visualization currently considered as relevant is a matrix (or heatmap) of properties * farms, with the cells colored according to the qualitative evaluation for each farm for a given property.

Note that plots are using a "\code{theme_idea()}" theme defined in this package.

A copy of the blank canvas used for colored trees can be locally exported as svg files with :

\code{IDEATools::show_canvas()}

Further information about the colored trees ans canvas can be found in this vignette :

\code{vignette("colored_trees", package = "IDEATools")}
}
\examples{
library(IDEATools)

## Example given for a single analysis. See diag_idea() for a group analysis.
path <- system.file("example_data/idea_example_1.json", package = "IDEATools")
my_data <- read_idea(path)
computed_data <- compute_idea(my_data)

## Example without radars or dimensions
idea_plots <- plot_idea(computed_data, choices = c("trees"))
}
