% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.theta}
\alias{get.theta}
\title{Generalized version of \code{get.theta}}
\usage{
get.theta(posmat, fun, r = 1, r.low = rep(0, length(r)))
}
\arguments{
\item{posmat}{a matrix with columns x, y and any other named columns
columns needed by fun}

\item{fun}{a function that takes in two rows of posmat and returns:
\enumerate{
     \item  for pairs that are (potentially) related
     \item for pairs that are unrelated
     \item for pairs that should be ignored all together}
Note that names from \code{posmat} are not preserved in calls to \code{fun}, so the columns of the matrix should be
referenced numerically
so this is not available to the fun}

\item{r}{the series of spatial distances (or there maximums) we are
interested in}

\item{r.low}{the low end of each range, 0 by default}
}
\value{
theta value for each distance range that we look at. Where:

\deqn{ \theta(d_1,d_2) = \frac{\sum \boldsymbol{1} (d_{ij} \in (d_1,d_2)) \boldsymbol{1} (f(i,j)=1) }{\sum \sum \boldsymbol{1} (d_{ij} \in (d_1,d_2)) \boldsymbol{1} (f(i,j)=2) }}
}
\description{
Generalized version of the \code{get.theta} function that takes in an arbitrary function and
returns the odds that a point within a particular range of a point of interest shares the relationship
specified by the passed in function with that point.
}
\examples{
data(DengueSimulationR02)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)

sero.type.func<-function(a,b,tlimit=20){
  if(a[5]==b[5]&(abs(a[3]-b[3])<=tlimit)){rc=1}
  else{rc=2}
  return(rc)
}

sero.theta<-get.theta(DengueSimR02,sero.type.func,r=r.max,r.low=r.min)
}
\author{
Justin Lessler and Henrik Salje
}
\seealso{
Other get.theta: \code{\link{get.theta.bootstrap}},
  \code{\link{get.theta.ci}},
  \code{\link{get.theta.permute}},
  \code{\link{get.theta.typed.bootstrap}},
  \code{\link{get.theta.typed.permute}},
  \code{\link{get.theta.typed}}

Other spatialtau: \code{\link{get.pi}},
  \code{\link{get.tau}}
}

