% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.typed.permute}
\alias{get.tau.typed.permute}
\title{get the null distribution for the \code{get.tau.typed} function}
\usage{
get.tau.typed.permute(posmat, typeA = -1, typeB = -1, r = 1,
  r.low = rep(0, length(r)), permutations,
  comparison.type = "representative", data.frame = TRUE)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{comparison.type}{what type of points are included in the comparison set.
\itemize{
  \item "representative" if comparison set is representative of the underlying population
  \item "independent" if comparison set is cases/events coming from an indepedent process
}}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
a matrix with permutation tau values for each distance specified
}
\description{
get the null distribution for the \code{get.tau.typed} function
}
\examples{
\donttest{

data(DengueSimulationR02)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)
r.mid<-(r.max+r.min)/2

#Lets see if there's a difference in spatial dependence by time case occurs
type <- 2 - (DengueSimR02[,"time"] < 120)
tmp <- cbind(DengueSimR02, type=type)

typed.tau <- get.tau.typed(tmp, typeA=1, typeB=2, r=r.max, r.low=r.min, 
                           comparison.type = "independent")

typed.tau.type.null<-get.tau.typed.permute(tmp, typeA=1, typeB=2, r=r.max, r.low=r.min, 
                                           permutations=100, comparison.type = "independent")

null.ci <- apply(typed.tau.type.null[,-(1:2)], 1, quantile, probs=c(0.025,0.975))

plot(r.mid, typed.tau$tau, ylim=c(0.3,4), log="y", cex.axis=1.25, 
     xlab="Distance (m)", ylab="Tau", cex.main=0.9, lwd=2, type="n")
abline(h=1,lty=1)
lines(r.mid,typed.tau$tau,pch=20,col=1,lwd=3)
lines(r.mid, null.ci[1,] , lty=2)
lines(r.mid, null.ci[2,] , lty=2)

}
}
\seealso{
Other get.tau: \code{\link{get.tau.bootstrap}},
  \code{\link{get.tau.ci}}, \code{\link{get.tau.permute}},
  \code{\link{get.tau.typed.bootstrap}},
  \code{\link{get.tau.typed}}, \code{\link{get.tau}}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.tau}
