% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau}
\alias{get.tau}
\title{generalized version of \code{get.tau}}
\usage{
get.tau(posmat, fun, r = 1, r.low = rep(0, length(r)),
  comparison.type = "representative")
}
\arguments{
\item{posmat}{a matrix with columns x, y and any other named columns
columns needed by fun}

\item{fun}{a function that takes in two rows of posmat and returns:
\enumerate{
     \item for pairs included in the numerator (and the denominator for independent data)
     \item for pairs that should only be included in the denominator
     \item for pairs that should be ignored all together}
Note that names from \code{posmat} are not preserved in calls to
\code{fun}, so the columns of the matrix should be referenced numerically
so this is not available to fun}

\item{r}{the series of spatial distances (or there maximums) we are
interested in}

\item{r.low}{the low end of each range, 0 by default}

\item{comparison.type}{what type of points are included in the comparison set.
\itemize{
  \item "representative" if comparison set is representative of the underlying population
  \item "independent" if comparison set is cases/events coming from an indepedent process
}}
}
\value{
The tau value for each distance we look at. If \code{comparison.type} is "representative", this is:

\code{tau = get.pi(posmat, fun, r, r.low)/get.pi(posmat,fun,0,infinity)}

If \code{comparison.type} is "independent", this is:

\code{tau = get.theta(posmat, fun, r, r.low)/get.theta(posmat,fun,0,infinity)}
}
\description{
returns the relative probability (or odds) that points at some distance
from an index point share some relationship with that point versus
the probability (or odds) any point shares that relationship with that point.
}
\examples{
\dontrun{
R/examples/get_tau.R
}

}
\seealso{
Other get.tau: \code{\link{get.tau.bootstrap}},
  \code{\link{get.tau.ci}}, \code{\link{get.tau.permute}},
  \code{\link{get.tau.typed.bootstrap}},
  \code{\link{get.tau.typed.permute}},
  \code{\link{get.tau.typed}}

Other spatialtau: \code{\link{get.pi}},
  \code{\link{get.theta}}
}
\author{
Justin Lessler and Henrik Salje
}
