% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_to_AST.R
\name{data_to_AST}
\alias{data_to_AST}
\title{AST File Writer}
\usage{
data_to_AST(
  obj,
  write_to,
  viewing_pop = "All",
  overwrite = FALSE,
  display_progress = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of 'obj$fileName'\cr
-\%p: with first parent directory of 'obj$fileName'\cr
-\%e: with extension of 'obj$fileName' (without leading .)\cr
-\%s: with shortname from 'obj$fileName' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. Note that it has to be a .ast.}

\item{viewing_pop}{Character String. Allow user to change displayed population. Default is 'All'.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.
Note that if TRUE, it will overwrite exported file if path of 'obj$fileName' and deduced from 'write_to' arguments are different.
Otherwise, you will get an error saying that overwriting source file is not allowed.\cr
Note also that an original file, i.e. generated by IDEAS(R) or INSPIRE(R), will never be overwritten.
Otherwise, you will get an error saying that overwriting original file is not allowed.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{...}{other arguments to be passed.}
}
\value{
It invisibly returns full path of exported file.
}
\description{
Writes an `IFC_data` object to a ast file
}
\keyword{internal}
