% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs.R
\name{readFCSdataset}
\alias{readFCSdataset}
\title{FCS Dataset Parser}
\usage{
readFCSdataset(fileName, options, display_progress = TRUE, ...)
}
\arguments{
\item{fileName}{path to file.}

\item{options}{list of options used to parse FCS file. It should contain (otherwise, it will be filled with the default values listed below):\cr
- header, a list whose members define the "at" offset from header$start$at and the "n" number of bytes to extract:\cr
-- start: where to start reading current FCS dataset.       Default is list(at = 0,  n = 6),\cr
-- space: where to retrieve space.                          Default is list(at = 6,  n = 4),\cr
-- text_beg: where to retrieve file text segment beginning. Default is list(at = 10, n = 8),\cr
-- text_end: where to retrieve file text segment end.       Default is list(at = 18, n = 8),\cr
-- data_beg: where to retrieve file data segment beginning. Default is list(at = 26, n = 8),\cr
-- data_end: where to retrieve file data segment end.       Default is list(at = 34, n = 8),\cr
- apply_scale, whether to apply data scaling. It only applies when fcs file is stored as DATATYPE "I". Default is TRUE.\cr
- dataset, (coerced to) an ordered vector of unique indices of desired dataset(s) to extract. Default is 1 to extract only the first dataset, whereas NULL allows to extract all available datasets.\cr
- force_header, whether to force the use of header to determine the position of data segment. Default is FALSE, for using positions found in "$BEGINDATA" and "$ENDDATA" keywords.\cr
- text_only, whether to only extract text segment. Default is FALSE.\cr
- text_check, whether to check if text segment is compliant with FCS specifications. Default is FALSE.\cr
- text_empty, whether to allow empty values when parsing text segment. Default is FALSE.\cr
- text_trim, remove whitespace in keywords names. Default is "none". Allowed are "both", "left", "right" and "none".}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{other arguments to be passed.}
}
\value{
a list containing:\cr
- options, list of 'options' used\cr
- header, list of header information corresponding to 'options'\cr
- delimiter, unique character used to separate keyword-value pairs\cr
- text, list of keywords values,\cr
- data, data.frame of values.
}
\description{
Helper to parse dataset from Flow Cytometry Standard (FCS) compliant files.
}
\details{
'options' may be tweaked according to file type, instrument and software used to generate it.\cr
Default 'options' should allow to read most files.\cr
'options' members with the exception of 'header' may be passed thanks to '...'.
}
\keyword{internal}
