% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveModel.R
\name{solveModel}
\alias{solveModel}
\title{Function to solve counterfactuals.}
\usage{
solveModel(
  N,
  L_i,
  L_j,
  K,
  t_ij,
  a,
  b,
  varphi,
  w_eq,
  u_eq,
  Q_eq,
  ttheta_eq,
  alpha = 0.7,
  beta = 0.7,
  theta = 7,
  mu = 0.3,
  delta = 0.3585,
  lambda = 0.01,
  rho = 0.9094,
  eta = 0.1548,
  epsilon = 0.01,
  zeta = 0.95,
  tol = 10^-10,
  maxiter = 1000
)
}
\arguments{
\item{N}{Integer - Number of locations.}

\item{L_i}{Nx1 array - Number of residents in each location}

\item{L_j}{Nx1 array - Number of workers in each location}

\item{K}{Nx1 array - Land supply}

\item{t_ij}{NxN matrix - Travel times across locations}

\item{a}{Nx1 array - Total Factor Productivity in each location}

\item{b}{Nx1 array - Vector of amenities in each location}

\item{varphi}{Nx1 array - Density of development}

\item{w_eq}{Nx1 array - Initial vector of wages}

\item{u_eq}{Nx1 array - Initial vector of welfare}

\item{Q_eq}{Nx1 array - Initial price for floorspace}

\item{ttheta_eq}{Nx1 array - Share of floorspace used commercially}

\item{alpha}{Float - Exp. share in consumption, 1-alpha exp. share in housing}

\item{beta}{Float - Output elasticity with respect to labor}

\item{theta}{Float - Commuting and migration elasticity.}

\item{mu}{Float - Floorspace prod function: output elasticity wrt capital}

\item{delta}{Float - Decay parameter agglomeration force}

\item{lambda}{Float - agglomeration externality}

\item{rho}{Float - decay parameter for amenities}

\item{eta}{Float - amenity externality}

\item{epsilon}{Float - Parameter that transforms travel times to commuting costs}

\item{zeta}{Float - convergence parameter}

\item{tol}{Int - tolerance factor}

\item{maxiter}{Integer - Maximum number of iterations for convergence.
Default maxiter=1000.}
}
\value{
Counterfactual values.
}
\description{
Function to solve counterfactuals.
}
\examples{
N=5
L_i = c(63, 261, 213, 182, 113)
L_j = c(86, 278, 189, 180, 99)
Q = c(2123, 1576, 1371, 1931, 1637)
K = c(0.44, 1.45, 1.15, 0.87, 0.58)
t_ij = rbind(c(0.0, 6.6, 5.5, 5.6, 6.4),
             c(6.7, 0.0, 3.9, 4.6, 4.4),
             c(5.5, 3.9, 0.0, 2.8, 3.0),
             c(5.6, 4.6, 2.8, 0.0, 2.7),
             c(6.4, 4.4, 3.0, 2.7, 0.0))

a = c(1.7, 1.7, 1.6, 1.8, 1.6)
b = c(2.2, 2.5, 2.4, 2.6, 2.3)
varphi = c(95, 219, 215, 167, 148)
w_eq = c(0.9, 1.0, 1.0, 1.0, 0.9)
u_eq = c(1.0, 1.3, 1.2, 1.2, 1.1)
Q_eq = c(1.2, 0.9, 0.8, 1.1, 0.9)
ttheta_eq = c(0.5, 0.4, 0.4, 0.4, 0.4)
solveModel(N=N,
           L_i=L_i,
           L_j=L_j,
           K=K,
           t_ij=t_ij,
           a=a,
           b=b,
           varphi=varphi,
           w_eq=w_eq,
           u_eq=u_eq,
           Q_eq=Q_eq,
           ttheta_eq=ttheta_eq)
           
}
