% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingFunctions.R
\name{show_digit}
\alias{show_digit}
\title{Show image of grayscale grid}
\usage{
show_digit(dat,
           col = NULL,
           ...)
}
\arguments{
\item{dat}{A \code{matrix} or \code{data.frame} with the same number of rows and columns (or a vector which can be coerced to such a format), representing a grayscale map of a single digit.}

\item{col}{The colour scale to be used. Defaults to \code{grey(seq(1, 0, length = ncol(dat)))}.}

\item{...}{Additional arguments to be passed to \code{\link{mat2cols}} and/or \code{\link{plot_cols}} (e.g. \code{na.col}) when \code{dat} is a matrix or \code{\link[graphics]{image}} when \code{dat} is a vector.}
}
\value{
The desired image representation of the digit.
}
\description{
Plots an image of a grayscale grid representation of a digit.
}
\examples{
data(USPSdigits)

# Plot the first digit
show_digit(USPSdigits$train[1,-1])

# Visualise the overall mean
show_digit(colMeans(USPSdigits$train[,-1]))
}
\seealso{
\code{\link{USPSdigits}}, \code{\link{show_IMIFA_digit}}, \code{\link{mat2cols}}, \code{\link{plot_cols}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{plotting}
