% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_LD.R
\name{plot_LD}
\alias{plot_LD}
\title{Plotting the estimated latent distribution}
\usage{
plot_LD(model, xlim = c(-6, 6))
}
\arguments{
\item{model}{An object obtained from either \code{\link{IRTest_Dich}}, \code{\link{IRTest_Poly}}, or \code{\link{IRTest_Mix}}.}

\item{xlim}{A vector of length 2 which determines the range of the plot.
The default is \code{c(-6, 6)}}
}
\value{
A plot of estimated latent distribution.
}
\description{
This function draws a plot of the estimated latent distribution (the prior distribution of the latent variable).
}
\examples{
# Data generation and model fitting

Alldata <- DataGeneration(seed = 1,
                          #model_D = rep(1, 10),
                          N=1000,
                          nitem_D = 0,
                          nitem_P = 8,
                          categ = rep(3:4,each = 4),
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)

data <- Alldata$data_P
item <- Alldata$item_P
initialitem <- Alldata$initialitem_P
theta <- Alldata$theta

M1 <- IRTest_Poly(initialitem = initialitem,
                  data = data,
                  model = "GPCM",
                  latent_dist = "Mixture",
                  max_iter = 200,
                  threshold = .001,
                  )


# Plotting the latent distribution

plot_LD(model=M1, xlim = c(-6, 6))

}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
