% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_app.R
\docType{class}
\name{select_aoi_global_grid}
\alias{select_aoi_global_grid}
\title{R6 Class to Select an Area of Interest (AOI) from a Global Grid}
\usage{
# init <- select_aoi_global_grid$new()
}
\description{
The 'select_aoi_global_grid' class will be used to select an Area of Interest (AOI) from the global grid
}
\examples{

\dontrun{

require(IceSat2R)
require(magrittr)

#........................................
# 1st. Option: Select an AOI from the map
#........................................

init = select_aoi_global_grid$new(area_of_interest = NULL,
                                  verbose = TRUE)
init$draw_edit_aoi()
sf_obj = init$selected_areas_global_grid(plot_data = TRUE)
sf_obj


#...............................................
# observe the available countries and continents
# using the 'rnaturalearth' R package
#...............................................

cntr_cnt = rnaturalearth::ne_countries(scale = 110,
                                       type = 'countries',
                                       returnclass = 'sf')

cntr_cnt = cntr_cnt[, c('sovereignt', 'continent')]

# sort(cntr_cnt$sovereignt)
# sort(unique(cntr_cnt$continent))


#.......................................
# 2nd. Option: Select a 'country' as AOI   (5-degrees query)
#.......................................

init = select_aoi_global_grid$new(area_of_interest = 'Antarctica',
                                  verbose = TRUE)

init$draw_edit_aoi(degrees = 5.0, square_geoms = TRUE)
sf_obj = init$selected_areas_global_grid(plot_data = TRUE)
sf_obj


#.........................................
# 3rd. Option: Select a 'continent' as AOI   (1-degree query)
#.........................................

init = select_aoi_global_grid$new(area_of_interest = 'North America',
                                  verbose = TRUE)

init$draw_edit_aoi(degrees = 1.0, square_geoms = TRUE)
sf_obj = init$selected_areas_global_grid(plot_data = TRUE)
sf_obj


#.........................................
# 4th. Option: Use a bounding box as input  ('Greenland Ice Sheet')
#.........................................

pth_bbx = system.file('data_files', 'ne_10m_glaciated_areas.RDS',
                      package = "IceSat2R")

dat_bbx = readRDS(file = pth_bbx) \%>\%
  subset(!is.na(name)) \%>\%
  subset(name == "Greenland Ice Sheet") \%>\%
  sf::st_bbox(crs = 4326)

dat_bbx

init = select_aoi_global_grid$new(area_of_interest = dat_bbx,
                                  verbose = TRUE)

init$draw_edit_aoi(degrees = 1.0, square_geoms = TRUE)
sf_obj = init$selected_areas_global_grid(plot_data = TRUE)
sf_obj


#......................................................
# 5th. Option: Create a global hexagonal 5-degrees grid
#......................................................

bbx_global = c(xmin = -180, xmax = 180, ymin = -90, ymax = 90)

init = select_aoi_global_grid$new(area_of_interest = bbx_global,
                                  verbose = TRUE)

init$draw_edit_aoi(degrees = 5.0, square_geoms = FALSE)
sf_obj = init$selected_areas_global_grid(plot_data = TRUE)
sf_obj

}
}
\references{
https://github.com/r-spatial/mapedit/blob/master/experiments/gadget_draw2.R
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{area_of_interest}}{an R object (character string, vector)}

\item{\code{leaflet_provider_base}}{a leaflet provider object}

\item{\code{leaflet_provider_secondary}}{a leaflet provider object}

\item{\code{crs_value}}{a numeric value}

\item{\code{use_s2}}{a boolean}

\item{\code{verbose}}{a boolean}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{select_aoi_global_grid$new()}}
\item \href{#method-draw_edit_internal}{\code{select_aoi_global_grid$draw_edit_internal()}}
\item \href{#method-draw_edit_aoi}{\code{select_aoi_global_grid$draw_edit_aoi()}}
\item \href{#method-selected_areas_global_grid}{\code{select_aoi_global_grid$selected_areas_global_grid()}}
\item \href{#method-selected_aoi_sf}{\code{select_aoi_global_grid$selected_aoi_sf()}}
\item \href{#method-clone}{\code{select_aoi_global_grid$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize method for the select_aoi_global_grid R6 class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{select_aoi_global_grid$new(
  area_of_interest = NULL,
  leaflet_provider_base = leaflet::providers$CartoDB.Positron,
  leaflet_provider_secondary = leaflet::providers$Esri.WorldImagery,
  crs_value = 4326,
  use_s2 = FALSE,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{area_of_interest}}{either NULL (which allows the user to draw the area of interest on the map) or a character string (i.e. a 'country' or a 'continent') or a named bounding box vector (such as c(xmin = 16.1, xmax = 16.6, ymax = 48.6, ymin = 47.9)). The 'countries' and 'continents' can be extracted from the "rnaturalearth::ne_countries(scale = 110, type = 'countries', returnclass = 'sf')" function and specifically the columns: 'sovereignt' and 'continent'}

\item{\code{leaflet_provider_base}}{a leaflet provider object}

\item{\code{leaflet_provider_secondary}}{a leaflet provider object}

\item{\code{crs_value}}{a value. The coordinate reference system. The default value of the crs is 4326}

\item{\code{use_s2}}{a boolean. If TRUE, use the s2 spherical geometry package for geographical coordinate operations (see the documentation of the 'sf::sf_use_s2()' function for more information)}

\item{\code{verbose}}{a boolean. If TRUE then information will be printed in the console}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-draw_edit_internal"></a>}}
\if{latex}{\out{\hypertarget{method-draw_edit_internal}{}}}
\subsection{Method \code{draw_edit_internal()}}{
Internal Shiny application to visualize the global grid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{select_aoi_global_grid$draw_edit_internal(lft_map)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lft_map}}{a leaflet map}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-draw_edit_aoi"></a>}}
\if{latex}{\out{\hypertarget{method-draw_edit_aoi}{}}}
\subsection{Method \code{draw_edit_aoi()}}{
Allows to view the Global Grid on the map including a popup that shows the Area of each grid rectangle (or hexagon). The user can then select an Area of Interest (AOI)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{select_aoi_global_grid$draw_edit_aoi(degrees = 1, square_geoms = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{degrees}}{a numeric value. This can be either 1.0 or 5.0 to allow queries to the 'OpenAltimetry' API}

\item{\code{square_geoms}}{a boolean. If FALSE then a hexagonal grid will be created}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-selected_areas_global_grid"></a>}}
\if{latex}{\out{\hypertarget{method-selected_areas_global_grid}{}}}
\subsection{Method \code{selected_areas_global_grid()}}{
Takes the selected Area(s) of Interest (AOI) from the draw_edit_aoi() method and returns a simple features object with the corresponding n-degree grid cells
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{select_aoi_global_grid$selected_areas_global_grid(plot_data = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_data}}{a boolean specifying if the selected from the user AOI's and the corresponding grid cells should be plotted side by side. If FALSE then only the simple features object will be returned. If TRUE and the initial 'area_of_interest' parameter is NULL then a single plot will be displayed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
either an 'sfc' object (if the initial 'area_of_interest' parameter is NULL) or an 'sf' object consisting of the n-degree grid cells
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-selected_aoi_sf"></a>}}
\if{latex}{\out{\hypertarget{method-selected_aoi_sf}{}}}
\subsection{Method \code{selected_aoi_sf()}}{
Returns the selected area of interest (AOI) by the user in form of an 'sfc' object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{select_aoi_global_grid$selected_aoi_sf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an 'sfc' object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{select_aoi_global_grid$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
