% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.insilico}
\alias{plot.insilico}
\title{plot CSMF from a "insilico" object}
\usage{
\method{plot}{insilico}(x, type = c("errorbar", "bar", "compare")[1],
  top = 10, causelist = NULL, which.sub = NULL, xlab = "Causes",
  ylab = "CSMF", title = "Top CSMF Distribution", horiz = TRUE,
  angle = 60, fill = "lightblue", err_width = 0.4, err_size = 0.6,
  point_size = 2, border = "black", bw = FALSE, ...)
}
\arguments{
\item{x}{fitted \code{"insilico"} object}

\item{type}{An indicator of the type of chart to plot. "errorbar" for line
plots of only the error bars on single population; "bar" for bar chart with
error bars on single population; "compare" for line charts on multiple
sub-populations.}

\item{top}{The number of top causes to plot. If multiple sub-populations are
to be plotted, it will plot the union of the top causes in all
sub-populations.}

\item{causelist}{The list of causes to plot. It could be a numeric vector
indicating the position of the causes in the InterVA cause list (see
\code{\link{causetext}}), or a vector of character string of the cause
names. The argument supports partial matching of the cause names. e.g.,
"HIV/AIDS related death" could be abbreviated into "HIV"; "Other and
unspecified infect dis" could be abbreviated into "Other and unspecified
infect".}

\item{which.sub}{Specification of which sub-population to plot if there are
multiple and \code{type} is set to "bar".}

\item{xlab}{Labels for the causes.}

\item{ylab}{Labels for the CSMF values.}

\item{title}{Title of the plot.}

\item{horiz}{Logical indicator indicating if the bars are plotted
horizontally.}

\item{angle}{Angle of rotation for the texts on x axis when \code{horiz} is
set to FALSE}

\item{fill}{The color to fill the bars when \code{type} is set to "bar".}

\item{err_width}{Size of the error bars.}

\item{err_size}{Thickness of the error bar lines.}

\item{point_size}{Size of the points.}

\item{border}{The color to color the borders of bars when \code{type} is set
to "bar".}

\item{bw}{Logical indicator for setting the theme of the plots to be black
and white.}

\item{\dots}{Not used.}
}
\description{
Produce a bar plot of the CSMFs for a fitted \code{"insilico"} object.
}
\details{
To-do
}
\examples{
\dontrun{
data(RandomVA1)
##
## Scenario 1: without sub-population specification
##
fit1<- insilico(RandomVA1, subpop = NULL,
              Nsim = 1000, burnin = 500, thin = 10 , seed = 1,
              auto.length = FALSE)
# basic line plot
plot(fit1)
# basic bar plot
plot(fit1, type = "bar")
# line plot with customized look
plot(fit1, top = 15, horiz = FALSE, fill = "gold",
           bw = TRUE, title = "Top 15 CSMFs", angle = 70,
           err_width = .2, err_size = .6, point_size = 2)

##
## Scenario 2: with sub-population specification
##
data(RandomVA2)
fit2<- insilico(RandomVA2, subpop = list("sex"),
              Nsim = 1000, burnin = 500, thin = 10 , seed = 1,
              auto.length = FALSE)
summary(fit2)
# basic side-by-side line plot for all sub-populations
plot(fit2, type = "compare", main = "Top 5 causes comparison")
# basic line plot for specific sub-population
plot(fit2, which.sub = "Women", main = "Top 5 causes for women")
# customized plot with only specified causes
# the cause names need not be exact as InterVA cause list
# substrings in InterVA cause list is enough for specification
# e.g. the following two specifications are the same
some_causes_1 <- c("HIV/AIDS related death", "Pulmonary tuberculosis")
some_causes_2 <- c("HIV", "Pulmonary")
plot(fit2, type = "compare", horiz = FALSE,  causelist = some_causes_1,
              title = "HIV and TB fractions in two sub-populations",
              angle = 20)
}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C.
Crampin, Kathleen Kahn and Samuel J. Clark Probabilistic cause-of-death
assignment using verbal autopsies, \emph{arXiv preprint arXiv:1411.3042}
\url{http://arxiv.org/abs/1411.3042} (2014)
}
\seealso{
\code{\link{insilico}}, \code{\link{summary.insilico}}
}
\keyword{InSilicoVA}

