/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tchar;

import cern.colt.PersistentObject;
import cern.colt.buffer.tchar.CharBuffer2DConsumer;
import cern.colt.list.tchar.CharArrayList;

public class CharBuffer2D
extends PersistentObject
implements CharBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected CharBuffer2DConsumer target;
    protected char[] xElements;
    protected char[] yElements;
    protected CharArrayList xList;
    protected CharArrayList yList;
    protected int capacity;
    protected int size;

    public CharBuffer2D(CharBuffer2DConsumer charBuffer2DConsumer, int n) {
        this.target = charBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new char[n];
        this.yElements = new char[n];
        this.xList = new CharArrayList(this.xElements);
        this.yList = new CharArrayList(this.yElements);
        this.size = 0;
    }

    public void add(char c, char c2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = c;
        this.yElements[this.size++] = c2;
    }

    public void addAllOf(CharArrayList charArrayList, CharArrayList charArrayList2) {
        int n = charArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(charArrayList, charArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

