/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    private double[][] elements;
    private DoubleFFT_2D fft2;
    private DoubleDCT_2D dct2;
    private DoubleDST_2D dst2;
    private DoubleDHT_2D dht2;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;
    private DoubleDCT_1D dctRows;
    private DoubleDCT_1D dctColumns;
    private DoubleDST_1D dstRows;
    private DoubleDST_1D dstColumns;
    private DoubleDHT_1D dhtRows;
    private DoubleDHT_1D dhtColumns;

    public DenseLargeDoubleMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new double[n][n2];
        this.content = this;
    }

    public void dct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dctColumns(final boolean bl) {
        int n;
        if (this.dctColumns == null) {
            this.dctColumns = new DoubleDCT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dctColumns.forward(dArray, bl);
                            DenseLargeDoubleMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.dctColumns.forward(dArray, bl);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void dctRows(final boolean bl) {
        int n;
        if (this.dctRows == null) {
            this.dctRows = new DoubleDCT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix2D.this.dctRows.forward(DenseLargeDoubleMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctRows.forward(this.elements[i], bl);
            }
        }
    }

    public void dht2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtColumns() {
        int n;
        if (this.dhtColumns == null) {
            this.dhtColumns = new DoubleDHT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dhtColumns.forward(dArray);
                            DenseLargeDoubleMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.dhtColumns.forward(dArray);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void dhtRows() {
        int n;
        if (this.dhtRows == null) {
            this.dhtRows = new DoubleDHT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix2D.this.dhtRows.forward(DenseLargeDoubleMatrix2D.this.elements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dhtRows.forward(this.elements[i]);
            }
        }
    }

    public void dst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.forward(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstColumns(final boolean bl) {
        int n;
        if (this.dstColumns == null) {
            this.dstColumns = new DoubleDST_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dstColumns.forward(dArray, bl);
                            DenseLargeDoubleMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.dstColumns.forward(dArray, bl);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void dstRows(final boolean bl) {
        int n;
        if (this.dstRows == null) {
            this.dstRows = new DoubleDST_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix2D.this.dstRows.forward(DenseLargeDoubleMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstRows.forward(this.elements[i], bl);
            }
        }
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseLargeDComplexMatrix2D getFft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        final double[][] dArray = denseLargeDComplexMatrix2D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[i], 0, dArray[i], 0, DenseLargeDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.elements[i], 0, dArray[i], 0, this.columns);
            }
        }
        this.fft2.realForwardFull(dArray);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix2D;
    }

    public DenseLargeDComplexMatrix2D getFftColumns() {
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[] dArray = new double[2 * DenseLargeDoubleMatrix2D.this.rows];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements(), 0, dArray, 0, DenseLargeDoubleMatrix2D.this.rows);
                            DenseLargeDoubleMatrix2D.this.fftColumns.realForwardFull(dArray);
                            denseLargeDComplexMatrix2D.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = new double[2 * this.rows];
                System.arraycopy(this.viewColumn(i).copy().elements(), 0, dArray, 0, this.rows);
                this.fftColumns.realForwardFull(dArray);
                denseLargeDComplexMatrix2D.viewColumn(i).assign(dArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix2D;
    }

    public DenseLargeDComplexMatrix2D getFftRows() {
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[] dArray = new double[2 * DenseLargeDoubleMatrix2D.this.columns];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[i], 0, dArray, 0, DenseLargeDoubleMatrix2D.this.columns);
                            DenseLargeDoubleMatrix2D.this.fftRows.realForwardFull(dArray);
                            denseLargeDComplexMatrix2D.viewRow(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                double[] dArray = new double[2 * this.columns];
                System.arraycopy(this.elements[i], 0, dArray, 0, this.columns);
                this.fftRows.realForwardFull(dArray);
                denseLargeDComplexMatrix2D.viewRow(i).assign(dArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix2D;
    }

    public DenseLargeDComplexMatrix2D getIfft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        final double[][] dArray = denseLargeDComplexMatrix2D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[i], 0, dArray[i], 0, DenseLargeDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.elements[i], 0, dArray[i], 0, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(dArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix2D;
    }

    public DenseLargeDComplexMatrix2D getIfftColumns(final boolean bl) {
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[] dArray = new double[2 * DenseLargeDoubleMatrix2D.this.rows];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements(), 0, dArray, 0, DenseLargeDoubleMatrix2D.this.rows);
                            DenseLargeDoubleMatrix2D.this.fftColumns.realInverseFull(dArray, bl);
                            denseLargeDComplexMatrix2D.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = new double[2 * this.rows];
                System.arraycopy(this.viewColumn(i).copy().elements(), 0, dArray, 0, this.rows);
                this.fftColumns.realInverseFull(dArray, bl);
                denseLargeDComplexMatrix2D.viewColumn(i).assign(dArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix2D;
    }

    public DenseLargeDComplexMatrix2D getIfftRows(final boolean bl) {
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[] dArray = new double[2 * DenseLargeDoubleMatrix2D.this.columns];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[i], 0, dArray, 0, DenseLargeDoubleMatrix2D.this.columns);
                            DenseLargeDoubleMatrix2D.this.fftRows.realInverseFull(dArray, bl);
                            denseLargeDComplexMatrix2D.viewRow(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                double[] dArray = new double[2 * this.columns];
                System.arraycopy(this.elements[i], 0, dArray, 0, this.columns);
                this.fftRows.realInverseFull(dArray, bl);
                denseLargeDComplexMatrix2D.viewRow(i).assign(dArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix2D;
    }

    public double getQuick(int n, int n2) {
        return this.elements[n][n2];
    }

    public void idct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctColumns(final boolean bl) {
        int n;
        if (this.dctColumns == null) {
            this.dctColumns = new DoubleDCT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dctColumns.inverse(dArray, bl);
                            DenseLargeDoubleMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.dctColumns.inverse(dArray, bl);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void idctRows(final boolean bl) {
        int n;
        if (this.dctRows == null) {
            this.dctRows = new DoubleDCT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix2D.this.dctRows.inverse(DenseLargeDoubleMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctRows.inverse(this.elements[i], bl);
            }
        }
    }

    public void idht2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtColumns(final boolean bl) {
        int n;
        if (this.dhtColumns == null) {
            this.dhtColumns = new DoubleDHT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dhtColumns.inverse(dArray, bl);
                            DenseLargeDoubleMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.dhtColumns.inverse(dArray, bl);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void idhtRows(final boolean bl) {
        int n;
        if (this.dhtRows == null) {
            this.dhtRows = new DoubleDHT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix2D.this.dhtRows.inverse(DenseLargeDoubleMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dhtRows.inverse(this.elements[i], bl);
            }
        }
    }

    public void idst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstColumns(final boolean bl) {
        int n;
        if (this.dstColumns == null) {
            this.dstColumns = new DoubleDST_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dstColumns.inverse(dArray, bl);
                            DenseLargeDoubleMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.dstColumns.inverse(dArray, bl);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void idstRows(final boolean bl) {
        int n;
        if (this.dstRows == null) {
            this.dstRows = new DoubleDST_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix2D.this.dstRows.inverse(DenseLargeDoubleMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstRows.inverse(this.elements[i], bl);
            }
        }
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[n][n2] = d;
    }

    public double[][] elements() {
        return this.elements;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new DenseLargeDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new DenseDoubleMatrix1D(n);
    }
}

