/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DelegateDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix3D;

public class WrapperDoubleMatrix3D
extends DoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix3D content;

    public WrapperDoubleMatrix3D(DoubleMatrix3D doubleMatrix3D) {
        block3: {
            if (doubleMatrix3D != null) {
                try {
                    this.setUp(doubleMatrix3D.slices(), doubleMatrix3D.rows(), doubleMatrix3D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = doubleMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public void dct3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dct3(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.dct3(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dct2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dct2Slices(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.dct2Slices(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dst3(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.dst3(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dst2Slices(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.dst2Slices(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht3() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dht3();
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.dht3();
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2Slices() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dht2Slices();
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.dht2Slices();
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft3() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).fft3();
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.fft3();
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeDComplexMatrix3D getFft3() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getFft3();
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getFft3();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix3D getIfft3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getIfft3(bl);
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getIfft3(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix3D getFft2Slices() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getFft2Slices();
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getFft2Slices();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix3D getIfft2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getIfft2Slices(bl);
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getIfft2Slices(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public void idct3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idct3(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.idct3(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idct2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idct2Slices(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.idct2Slices(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idst3(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.idst3(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idst2Slices(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.idst2Slices(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idht3(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.idht3(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idht2Slices(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.idht2Slices(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft3(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).ifft3(bl);
            } else {
                DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = (DenseLargeDoubleMatrix3D)this.copy();
                denseLargeDoubleMatrix3D.ifft3(bl);
                this.assign(denseLargeDoubleMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized double getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public DoubleMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, double d) {
        this.content.setQuick(n, n2, n3, d);
    }

    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseDoubleMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateDoubleMatrix2D(this, 2, n);
    }

    public DoubleMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, d);
            }

            public synchronized double get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, double d) {
                this.content.set(n, n2, this.columns - 1 - n3, d);
            }
        };
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    public DoubleMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateDoubleMatrix2D(this, 0, n);
    }

    public DoubleMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, d);
            }

            public synchronized double get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, double d) {
                this.content.set(this.slices - 1 - n, n2, n3, d);
            }
        };
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    public DoubleMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d) {
                    this.content.setQuick(n2, n, n3, d);
                }

                public synchronized double get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, double d) {
                    this.content.set(n2, n, n3, d);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d) {
                    this.content.setQuick(n2, n3, n, d);
                }

                public synchronized double get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, double d) {
                    this.content.set(n2, n3, n, d);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d) {
                    this.content.setQuick(n3, n2, n, d);
                }

                public synchronized double get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, double d) {
                    this.content.set(n3, n2, n, d);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d) {
                    this.content.setQuick(n3, n, n2, d);
                }

                public synchronized double get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, double d) {
                    this.content.set(n3, n, n2, d);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperDoubleMatrix3D.slices = nArray[n];
        wrapperDoubleMatrix3D.rows = nArray[n2];
        wrapperDoubleMatrix3D.columns = nArray[n3];
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    public DoubleMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, double d) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, d);
            }

            public synchronized double get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n4, int n22, int n32, double d) {
                this.content.set(n + n4, n2 + n22, n3 + n32, d);
            }
        };
        wrapperDoubleMatrix3D.slices = n4;
        wrapperDoubleMatrix3D.rows = n5;
        wrapperDoubleMatrix3D.columns = n6;
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    public DoubleMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateDoubleMatrix2D(this, 1, n);
    }

    public DoubleMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, d);
            }

            public synchronized double get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, double d) {
                this.content.set(n, this.rows - 1 - n2, n3, d);
            }
        };
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    public DoubleMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], d);
            }

            public synchronized double get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, double d) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], d);
            }
        };
        wrapperDoubleMatrix3D.slices = nArray.length;
        wrapperDoubleMatrix3D.rows = nArray2.length;
        wrapperDoubleMatrix3D.columns = nArray3.length;
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    public DoubleMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix3D wrapperDoubleMatrix3D = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, double d) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, d);
            }

            public synchronized double get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n4, int n22, int n32, double d) {
                this.content.set(n * n4, n2 * n22, n3 * n32, d);
            }
        };
        if (this.slices != 0) {
            wrapperDoubleMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperDoubleMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperDoubleMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperDoubleMatrix3D.isNoView = false;
        return wrapperDoubleMatrix3D;
    }

    protected DoubleMatrix3D getContent() {
        return this.content;
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected DoubleMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected DoubleMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }
}

