/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfloat;

import cern.colt.Timer;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFloatProcedure;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;

public class FloatFunctions {
    public static final FloatFunctions functions = new FloatFunctions();
    public static final FloatFunction abs = new FloatFunction(){

        public final float apply(float f) {
            return Math.abs(f);
        }
    };
    public static final FloatFunction acos = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.acos(f);
        }
    };
    public static final FloatFunction asin = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.asin(f);
        }
    };
    public static final FloatFunction atan = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.atan(f);
        }
    };
    public static final FloatFunction ceil = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.ceil(f);
        }
    };
    public static final FloatFunction cos = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.cos(f);
        }
    };
    public static final FloatFunction exp = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.exp(f);
        }
    };
    public static final FloatFunction floor = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.floor(f);
        }
    };
    public static final FloatFunction identity = new FloatFunction(){

        public final float apply(float f) {
            return f;
        }
    };
    public static final FloatFunction inv = new FloatFunction(){

        public final float apply(float f) {
            return (float)(1.0 / (double)f);
        }
    };
    public static final FloatFunction log = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.log(f);
        }
    };
    public static final FloatFunction log2 = new FloatFunction(){

        public final float apply(float f) {
            return (float)(Math.log(f) * 1.4426950408889634);
        }
    };
    public static final FloatFunction neg = new FloatFunction(){

        public final float apply(float f) {
            return -f;
        }
    };
    public static final FloatFunction rint = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.rint(f);
        }
    };
    public static final FloatFunction sign = new FloatFunction(){

        public final float apply(float f) {
            return f < 0.0f ? -1.0f : (f > 0.0f ? 1.0f : 0.0f);
        }
    };
    public static final FloatFunction sin = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.sin(f);
        }
    };
    public static final FloatFunction sqrt = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.sqrt(f);
        }
    };
    public static final FloatFunction square = new FloatFunction(){

        public final float apply(float f) {
            return f * f;
        }
    };
    public static final FloatFunction tan = new FloatFunction(){

        public final float apply(float f) {
            return (float)Math.tan(f);
        }
    };
    public static final FloatFloatFunction atan2 = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return (float)Math.atan2(f, f2);
        }
    };
    public static final FloatFloatFunction compare = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f < f2 ? -1.0f : (f > f2 ? 1.0f : 0.0f);
        }
    };
    public static final FloatFloatFunction div = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f / f2;
        }
    };
    public static final FloatFloatFunction divNeg = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return -(f / f2);
        }
    };
    public static final FloatFloatFunction equals = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f == f2 ? 1.0f : 0.0f;
        }
    };
    public static final FloatFloatFunction greater = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f > f2 ? 1.0f : 0.0f;
        }
    };
    public static final FloatFloatFunction IEEEremainder = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return (float)Math.IEEEremainder(f, f2);
        }
    };
    public static final FloatFloatProcedure isEqual = new FloatFloatProcedure(){

        public final boolean apply(float f, float f2) {
            return f == f2;
        }
    };
    public static final FloatFloatProcedure isLess = new FloatFloatProcedure(){

        public final boolean apply(float f, float f2) {
            return f < f2;
        }
    };
    public static final FloatFloatProcedure isGreater = new FloatFloatProcedure(){

        public final boolean apply(float f, float f2) {
            return f > f2;
        }
    };
    public static final FloatFloatFunction less = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f < f2 ? 1.0f : 0.0f;
        }
    };
    public static final FloatFloatFunction lg = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return (float)(Math.log(f) / Math.log(f2));
        }
    };
    public static final FloatFloatFunction max = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return Math.max(f, f2);
        }
    };
    public static final FloatFloatFunction min = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return Math.min(f, f2);
        }
    };
    public static final FloatFloatFunction minus = FloatFunctions.plusMultSecond(-1.0f);
    public static final FloatFloatFunction mod = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f % f2;
        }
    };
    public static final FloatFloatFunction mult = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f * f2;
        }
    };
    public static final FloatFloatFunction multNeg = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return -(f * f2);
        }
    };
    public static final FloatFloatFunction multSquare = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return f * f2 * f2;
        }
    };
    public static final FloatFloatFunction plus = FloatFunctions.plusMultSecond(1.0f);
    public static final FloatFloatFunction plusAbs = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return Math.abs(f) + Math.abs(f2);
        }
    };
    public static final FloatFloatFunction pow = new FloatFloatFunction(){

        public final float apply(float f, float f2) {
            return (float)Math.pow(f, f2);
        }
    };

    protected FloatFunctions() {
    }

    public static FloatFunction between(final float f, final float f2) {
        return new FloatFunction(){

            public final float apply(float f3) {
                return f <= f3 && f3 <= f2 ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction bindArg1(final FloatFloatFunction floatFloatFunction, final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return floatFloatFunction.apply(f, f2);
            }
        };
    }

    public static FloatFunction bindArg2(final FloatFloatFunction floatFloatFunction, final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return floatFloatFunction.apply(f2, f);
            }
        };
    }

    public static FloatFloatFunction chain(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, final FloatFunction floatFunction2) {
        return new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return floatFloatFunction.apply(floatFunction.apply(f), floatFunction2.apply(f2));
            }
        };
    }

    public static FloatFloatFunction chain(final FloatFunction floatFunction, final FloatFloatFunction floatFloatFunction) {
        return new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return floatFunction.apply(floatFloatFunction.apply(f, f2));
            }
        };
    }

    public static FloatFunction chain(final FloatFunction floatFunction, final FloatFunction floatFunction2) {
        return new FloatFunction(){

            public final float apply(float f) {
                return floatFunction.apply(floatFunction2.apply(f));
            }
        };
    }

    public static FloatFunction compare(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f2 < f ? -1.0f : (f2 > f ? 1.0f : 0.0f);
            }
        };
    }

    public static FloatFunction constant(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f;
            }
        };
    }

    public static void demo1() {
        FloatFunctions floatFunctions = functions;
        float f = 0.5f;
        float f2 = 0.2f;
        float f3 = (float)(Math.sin(f) + Math.pow(Math.cos(f2), 2.0));
        System.out.println(f3);
        FloatFloatFunction floatFloatFunction = FloatFunctions.chain(plus, sin, FloatFunctions.chain(square, cos));
        System.out.println(floatFloatFunction.apply(f, f2));
        FloatFloatFunction floatFloatFunction2 = new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return (float)(Math.sin(f) + Math.pow(Math.cos(f2), 2.0));
            }
        };
        System.out.println(floatFloatFunction2.apply(f, f2));
        FloatFunction floatFunction = FloatFunctions.plus(3.0f);
        FloatFunction floatFunction2 = FloatFunctions.plus(4.0f);
        System.out.println(floatFunction.apply(0.0f));
        System.out.println(floatFunction2.apply(0.0f));
    }

    public static void demo2(int n) {
        FloatFunctions floatFunctions = functions;
        System.out.println("\n\n");
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = (float)Math.abs(Math.sin(f) + Math.pow(Math.cos(f2), 2.0));
        System.out.println(f3);
        FloatFloatFunction floatFloatFunction = FloatFunctions.chain(abs, FloatFunctions.chain(plus, sin, FloatFunctions.chain(square, cos)));
        System.out.println(floatFloatFunction.apply(f, f2));
        FloatFloatFunction floatFloatFunction2 = new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return (float)Math.abs(Math.sin(f) + Math.pow(Math.cos(f2), 2.0));
            }
        };
        System.out.println(floatFloatFunction2.apply(f, f2));
        Timer timer = new Timer().start();
        f = 0.0f;
        f2 = 0.0f;
        float f4 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            f4 += f;
            f += 1.0f;
            f2 += 1.0f;
        }
        timer.stop().display();
        System.out.println("empty sum=" + f4);
        Timer timer2 = new Timer().start();
        f = 0.0f;
        f2 = 0.0f;
        f4 = 0.0f;
        int n3 = n;
        while (--n3 >= 0) {
            f4 = (float)((double)f4 + Math.abs(Math.sin(f) + Math.pow(Math.cos(f2), 2.0)));
            f += 1.0f;
            f2 += 1.0f;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (double)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + f4);
        timer2.reset().start();
        f = 0.0f;
        f2 = 0.0f;
        f4 = 0.0f;
        n3 = n;
        while (--n3 >= 0) {
            f4 += floatFloatFunction.apply(f, f2);
            f += 1.0f;
            f2 += 1.0f;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (double)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + f4);
        timer2.reset().start();
        f = 0.0f;
        f2 = 0.0f;
        f4 = 0.0f;
        n3 = n;
        while (--n3 >= 0) {
            f4 += floatFloatFunction2.apply(f, f2);
            f += 1.0f;
            f2 += 1.0f;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (double)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + f4);
    }

    public static FloatFunction div(float f) {
        return FloatFunctions.mult(1.0f / f);
    }

    public static FloatFunction equals(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f2 == f ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction greater(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f2 > f ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction IEEEremainder(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return (float)Math.IEEEremainder(f2, f);
            }
        };
    }

    public static FloatProcedure isBetween(final float f, final float f2) {
        return new FloatProcedure(){

            public final boolean apply(float f3) {
                return f <= f3 && f3 <= f2;
            }
        };
    }

    public static FloatProcedure isEqual(final float f) {
        return new FloatProcedure(){

            public final boolean apply(float f2) {
                return f2 == f;
            }
        };
    }

    public static FloatProcedure isGreater(final float f) {
        return new FloatProcedure(){

            public final boolean apply(float f2) {
                return f2 > f;
            }
        };
    }

    public static FloatProcedure isLess(final float f) {
        return new FloatProcedure(){

            public final boolean apply(float f2) {
                return f2 < f;
            }
        };
    }

    public static FloatFunction less(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f2 < f ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction lg(final float f) {
        return new FloatFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(f);
            }

            public final float apply(float f2) {
                return (float)(Math.log(f2) * this.logInv);
            }
        };
    }

    protected static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        FloatFunctions.demo2(n);
    }

    public static FloatFunction max(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return Math.max(f2, f);
            }
        };
    }

    public static FloatFunction min(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return Math.min(f2, f);
            }
        };
    }

    public static FloatFunction minus(float f) {
        return FloatFunctions.plus(-f);
    }

    public static FloatFloatFunction minusMult(float f) {
        return FloatFunctions.plusMultSecond(-f);
    }

    public static FloatFunction mod(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f2 % f;
            }
        };
    }

    public static FloatFunction mult(float f) {
        return new FloatMult(f);
    }

    public static FloatFunction plus(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return f2 + f;
            }
        };
    }

    public static FloatFloatFunction multSecond(final float f) {
        return new FloatFloatFunction(){

            public final float apply(float f3, float f2) {
                return f2 * f;
            }
        };
    }

    public static FloatFloatFunction plusMultSecond(float f) {
        return new FloatPlusMultSecond(f);
    }

    public static FloatFloatFunction plusMultFirst(float f) {
        return new FloatPlusMultFirst(f);
    }

    public static FloatFunction pow(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return (float)Math.pow(f2, f);
            }
        };
    }

    public static FloatFunction random() {
        return new RandomFloatFunction();
    }

    public static FloatFunction round(final float f) {
        return new FloatFunction(){

            public final float apply(float f2) {
                return (float)(Math.rint(f2 / f) * (double)f);
            }
        };
    }

    public static FloatFloatFunction swapArgs(final FloatFloatFunction floatFloatFunction) {
        return new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return floatFloatFunction.apply(f2, f);
            }
        };
    }

    private static class RandomFloatFunction
    implements FloatFunction {
        private RandomFloatFunction() {
        }

        public float apply(float f) {
            return (float)Math.random();
        }
    }
}

