% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePrevalence.R
\name{estimatePointPrevalence}
\alias{estimatePointPrevalence}
\title{Estimate point prevalence}
\usage{
estimatePointPrevalence(
  cdm,
  denominatorTable,
  outcomeTable,
  denominatorCohortId = NULL,
  outcomeCohortId = NULL,
  interval = "years",
  timePoint = "start",
  strata = list(),
  includeOverallStrata = TRUE,
  minCellCount = 5
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{denominatorTable}{A cohort table with a set of denominator cohorts
(for example, created using the \code{generateDenominatorCohortSet()}
function).}

\item{outcomeTable}{A cohort table in the cdm reference containing
a set of outcome cohorts.}

\item{denominatorCohortId}{The cohort definition ids of the denominator
cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{outcomeCohortId}{The cohort definition ids of the outcome
cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{interval}{Time intervals over which period prevalence is estimated. Can
be "weeks", "months", "quarters", or "years". ISO weeks will
be used for weeks. Calendar months, quarters, or years can be used as
the period. If more than one option is chosen then results will
be estimated for each chosen interval.}

\item{timePoint}{where to compute the point prevalence}

\item{strata}{Variables added to the denominator cohort table for which to
stratify estimates.}

\item{includeOverallStrata}{Whether to include an overall result as well as
strata specific results (when strata has been specified).}

\item{minCellCount}{Minimum number of events to report- results
lower than this will be obscured. If NULL all results will be reported.}
}
\value{
Point prevalence estimates
}
\description{
Estimate point prevalence
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome",
  interval = "months"
)
}
}
