% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINTregression.R
\name{MINTregression}
\alias{MINTregression}
\title{MINTregression}
\usage{
MINTregression(x, y, k, keps, w = FALSE, eps)
}
\arguments{
\item{x}{The \eqn{n \times p} design matrix.}

\item{y}{The response vector of length \eqn{n}.}

\item{k}{The value of \eqn{k} to be used for estimation of the joint entropy \eqn{H(X,\epsilon)}.}

\item{keps}{The value of \eqn{k} to be used for estimation of the marginal entropy \eqn{H(\epsilon)}.}

\item{w}{The weight vector to be used for estimation of the joint entropy \eqn{H(X,\epsilon)}, with the same options as for the \code{\link{KLentropy}} function.}

\item{eps}{A vector of null errors which should have the same distribution as the errors are assumed to have in the linear model.}
}
\value{
The \eqn{p}-value corresponding the independence test carried out.
}
\description{
Performs a goodness-of-fit test of a linear model by testing whether the errors are independent of the covariates.
}
\examples{
# Correctly specified linear model
x=runif(100,min=-1.5,max=1.5); y=x+rnorm(100)
plot(lm(y~x),which=1) 
MINTregression(x,y,5,10,w=FALSE,rnorm(10000))
# Misspecified mean linear model
x=runif(100,min=-1.5,max=1.5); y=x^3+rnorm(100)
plot(lm(y~x),which=1)
MINTregression(x,y,5,10,w=FALSE,rnorm(10000))
# Heteroscedastic linear model
x=runif(100,min=-1.5,max=1.5); y=x+x*rnorm(100);
plot(lm(y~x),which=1) 
MINTregression(x,y,5,10,w=FALSE,rnorm(10000))
# Multivariate misspecified mean linear model
x=matrix(runif(1500,min=-1.5,max=1.5),ncol=3)
y=x[,1]^3+0.3*x[,2]-0.3*x[,3]+rnorm(500)
plot(lm(y~x),which=1)
MINTregression(x,y,30,50,w=TRUE,rnorm(50000))  

}
\references{
\insertRef{2017arXiv171106642B}{IndepTest}
}
