% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{calibrate}
\alias{calibrate}
\title{Plot individual calibrated dates.}
\usage{
calibrate(
  age = 2450,
  error = 50,
  cc = 1,
  postbomb = FALSE,
  reservoir = 0,
  prob = 0.95,
  BCAD = FALSE,
  ka = FALSE,
  cal.lab = c(),
  C14.lab = c(),
  cal.lim = c(),
  C14.lim = c(),
  cc.col = rgb(0, 0.5, 0, 0.7),
  cc.fill = rgb(0, 0.5, 0, 0.7),
  date.col = "red",
  dist.col = rgb(0, 0, 0, 0.2),
  dist.fill = rgb(0, 0, 0, 0.2),
  hpd.fill = rgb(0, 0, 0, 0.3),
  dist.height = 0.3,
  cal.rev = FALSE,
  yr.steps = FALSE,
  threshold = 5e-04,
  edge = TRUE,
  calibt = FALSE,
  rounded = 1,
  extend.range = 0.05,
  legend.cex = 0.8,
  legend1.loc = "topleft",
  legend2.loc = "topright",
  mgp = c(2, 1, 0),
  mar = c(3, 3, 1, 1),
  xaxs = "i",
  yaxs = "i",
  bty = "l",
  ...
)
}
\arguments{
\item{age}{Mean of the uncalibrated C-14 age.}

\item{error}{Error of the uncalibrated C-14 age.}

\item{cc}{Calibration curve for C-14 dates (1, 2, 3, or 4, or, e.g., "IntCal20", "Marine20", "SHCal20", "nh1", "sh3", or "mixed").}

\item{postbomb}{Whether or not this is a postbomb age. Defaults to FALSE.}

\item{reservoir}{Reservoir age, or reservoir age and age offset.}

\item{prob}{Probability confidence intervals (between 0 and 1).}

\item{BCAD}{Use BC/AD or cal BP scale (default cal BP).}

\item{ka}{Use thousands of years instead of years in the plots and hpd ranges. Defaults to FALSE.}

\item{cal.lab}{Label of the calendar/horizontal axis. Defaults to the calendar scale, but alternative names can be provided.}

\item{C14.lab}{Label of the C-14/vertical axis. Defaults to the 14C scale, but alternative names can be provided.}

\item{cal.lim}{Minimum and maximum of calendar axis (default calculated automatically).}

\item{C14.lim}{Minimum and maximum of C-14 axis (default calculated automatically).}

\item{cc.col}{Colour of the lines of the calibration curve. Defaults to semi-transparent dark green; \code{cc.col=rgb(0,.5,0,0.7)}.}

\item{cc.fill}{Colour of the inner part of the calibration curve. Defaults to semi-transparent dark green; \code{cc.col=rgb(0,.5,0,0.7)}.}

\item{date.col}{Colour of the "dot-bar" plot of the C14 date. Defaults to \code{date.col="red"}.}

\item{dist.col}{Colour of the outer lines of the distributions. Defaults to semi-transparent grey, \code{dist.col=rgb(0,0,0,0.2)}.}

\item{dist.fill}{Colour of the inner part of the distributions. Defaults to semi-transparent grey, \code{dist.col=rgb(0,0,0,0.2)}.}

\item{hpd.fill}{Colour of the highest posterior density. Defaults to semi-transparent grey, \code{dist.col=rgb(0,0,0,0.3)}.}

\item{dist.height}{Maximum height of the C14 and calibrated distributions (as proportion of the invisible secondary axes). Defaults to 0.3.}

\item{cal.rev}{Whether or not to reverse the direction of the calendar axis.}

\item{yr.steps}{Temporal resolution at which C-14 ages are calibrated (in calendar years). By default follows the spacing in the calibration curve.}

\item{threshold}{Below which value should probabilities be excluded from calculations.}

\item{edge}{How to treat dates are at or beyond the edge of the calibration curve. If dates are truncated, a warning is given. If they lie beyond the calibration curve, an error is given.}

\item{calibt}{Calibration based on the student-t distribution. By default, the Gaussian distribution is used (\code{calibt=FALSE}). To use the student-t distribution, provide two parameters such as \code{calibt=c(3,4)}.}

\item{rounded}{Rounding of the percentages of the reported hpd ranges. Defaults to 1 decimal.}

\item{extend.range}{Range by which the axes are extended beyond the data limits. Defaults to 5\%.}

\item{legend.cex}{Size of the font of the legends. Defaults to 0.8.}

\item{legend1.loc}{Where the first legend (with the calibration curve name and the uncalibrated date) is plotted. Defaults to topleft.}

\item{legend2.loc}{Where the second legend (with the hpd ranges) is plotted. Defaults to topright.}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted).}

\item{mar}{Plot margins (amount of white space along edges of axes 1-4).}

\item{xaxs}{Whether or not to extend the limits of the horizontal axis. Defaults to \code{xaxs="i"} which does not extend the limits.}

\item{yaxs}{Whether or not to extend the limits of the vertical axis. Defaults to \code{yaxs="i"} which does not extend the limits.}

\item{bty}{Draw a box around the graph ("n" for none, and "l", "7", "c", "u", "]" or "o" for correspondingly shaped boxes).}

\item{...}{Other plotting parameters.}
}
\value{
A graph of the raw and calibrated C-14 date, the calibrated ranges and, invisibly, the calibrated distribution and hpd ranges.
}
\description{
Calibrate individual 14C dates, plot them and report calibrated ranges.
}
\details{
Type \code{calibrate()} to see how a date of 2450 +- 50 14C BP gets calibrated (the calibration curve happens to show
a plateau around this 14C age). To calibrate a different date, provide its reported mean and error (1
standard deviation error as reported by the radiocarbon laboratory) as follows: \code{calibrate(mean, error)},
e.g., for a date of 130 +- 20 14C BP, type calibrate\code{(age=130, error=20)} or, shorter, \code{calibrate(130,20)}.

In case the date has a reservoir effect or age offset, e.g. of 100 14C years, provide this as follows:
\code{calibrate(130, 20, reservoir=100)}. If you want to include an uncertainty for this offset, provide this as follows,
e.g., for an uncertainty of 50yr, \code{calibrate(130,20,reservoir=c(100, 50))}.
The uncertainty for the age offset will then be added to the error (by taking the square root of the sum
of the squared error and the squared offset uncertainty). If the carbon of your sample has mixed marine/terrestrial sources,
instead apply the marine offset using mix.curves and calibrate the date using that custom-built curve (cc="mixed").

If you prefer to work with, e.g., 68 \% as opposed to the default 95 \% confidence intervals,
type: \code{calibrate(130, 20, prob=0.68)} or \code{calibrate(130, 20,, 0.68)} (the commas between the brackets indicate the position of the option;
the standard deviation is the fourth option of the \code{calibrate} function). The calibrated distribution can be calculated
for every single calendar year (\code{yrsteps=1}) within a wide range of the 14C date. Probabilities below a threshold (default \code{threshold=0.0005}) will be neglected.

By default the northern hemisphere terrestrial calibration curve is used (\code{cc=1 or cc1="IntCal20"}).
To use alternative curves, use \code{cc=2} (\code{cc2="Marine20"}), \code{cc=3} (\code{cc3="SHCal20C"}),
\code{cc=4} (\code{cc4="mixed.14C"}), or specify a postbomb curve (e.g., \code{cc="nh1"}).

Calibrate works in cal BP (calendar years before AD 1950) by default, but can work with cal BC/AD through the option \code{BCAD=TRUE}.

By default the Gaussian distribution is used to calibrate dates. For use of the student-t distribution instead,
provide two sensible values, e.g., \code{calibt=c(3,4)}.

Calibrated distributions are usually reduced to their 68\% or 95\% calibrated ranges, taking into account the asymmetric
and multi-peaked shape of these distributions.
Calibrated ranges at 68\% will obviously result in narrower confidence intervals, and a perceived higher precision, than 95\% ranges. However, given the often
asymmetric and multi-modal nature of calibrated distributions, the probability that the 'true' calendar date
lies outside the 1 standard deviation hpd ranges is considerable (c. 32\%). Therefore the use of 95\% calibrated ranges is preferable,
and default.

Negative radiocarbon ages are calibrated with postbomb curves, but the user needs to tell which curve to use.
For example, to use the first of the three northern hemisphere curves, provide the option \code{cc="nh1"}, \code{cc="nh2"}, \code{cc="nh3"},
while for southern hemisphere samples, use \code{cc="sh1-2"} or \code{cc="sh3"}.

A graph of the calibration is produced, and it can be adapted in several ways.
The limits of the horizontal (calendar scale) and vertical (14C scale) axes are calculated automatically
but can be changed by providing alternative values for the options \code{cal.lim, C14.lim}.
The titles of both axis can be changed by providing alternative titles to \code{cal.lab} and/or \code{C14.lab}. The heights of the distributions of the 14C and calibrated
ages can be set to alternative values using \code{dist.height} (default \code{0.3} which plots the distribution up to 30\% of the height of the entire graph).
Parameters for white space around the
graph can be changed (default \code{mar=c(3.5, 2, 2, 1}) for spacing below, to the left, above and to the right respectively),
as can the spacing for the axis labels (\code{mgp=c(2,1,0)}). By default, the axes are connected at the lower left, \code{bty="l"}.
Check the R documentation of \code{par()} for more options.

The colours of the 14C date, the calibration curve, the distributions, and the highest posterior density (hpd)
ranges, can be changed by providing an alternative colour in \code{date.col}, \code{cc.col}, \code{dist.col}, and/or \code{hpd.col}, respectively.
The default colours are transparent grey for the dates probability distributions (\code{dist.col=rgb(0,0,0, 0.3)} and \code{sd.col=rgb(0,0,0, 0.5)};
change the last value of rgb for different greyscale values), red for the uncalibrated mean and error bars (\code{date.col="red"}),
and transparent green for the calibration curve (\code{cc.col=rgb(0, 0.5, 0, 0.7)}). R's rgb() function expects values between \code{0} and \code{1}
for red, green and blue, respectively, followed by a value for the semi-transparency (also between 0 and 1). Some graphic devices
such as postscript are unable to use transparency; in that case provide different colours or leave the fourth value empty.
}
\examples{
calibrate()
calibrate(130, 20)
cal <- calibrate(2550, 20, reservoir=100)
cal; plot(cal[[1]])
calibrate(130, 20, prob=0.68)
calibrate(age=130, error=20, BCAD=TRUE)
calibrate(4450, 40, reservoir=c(100, 50))
}
