% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_interaction.R
\name{generate_interaction}
\alias{generate_interaction}
\title{Generate interaction data set}
\usage{
generate_interaction(
  N,
  r.x1.y,
  r.x2.y,
  r.x1x2.y,
  r.x1.x2,
  rel.x1 = 1,
  rel.x2 = 1,
  rel.y = 1,
  k.x1 = 0,
  k.x2 = 0,
  k.y = 0,
  adjust.correlations = TRUE,
  tol = 0.005,
  iter = 10,
  N.adjustment = 1e+06,
  r.x1.y.adjust = NULL,
  r.x2.y.adjust = NULL,
  r.x1.x2.adjust = NULL,
  r.x1x2.y.adjust = NULL,
  internal.adjust = FALSE,
  skew.x1 = NA,
  skew.x2 = NA,
  skew.y = NA
)
}
\arguments{
\item{N}{Sample size. Must be a positive integer. Has no default value.}

\item{r.x1.y}{Pearson's correlation between x1 and y. Must be between -1 and 1. Has no default value.}

\item{r.x2.y}{Pearson's correlation between x2 and y. Must be between -1 and 1. Assumed to be the 'moderator' in some functions. Has no default value.}

\item{r.x1x2.y}{Pearson's correlation between the interaction term x1x2 (x1 * x2) and y. Must be between -1 and 1. Has no default value.}

\item{r.x1.x2}{Pearson's correlation between x1 and x2. Must be between -1 and 1. Has no default value.}

\item{rel.x1}{Reliability of x1 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.x2}{Reliability of x2 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.y}{Reliability of xy (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{k.x1}{Number of discrete values for x1. Can be used to make a variable binary or ordinal.}

\item{k.x2}{Number of discrete values for x2. Can be used to make a variable binary or ordinal.}

\item{k.y}{Number of discrete values for y.Can be used to make a variable binary or ordinal.}

\item{adjust.correlations}{If variables are ordinal or binary, should correlations be adjusted so that output data has the specified correlation structure? Default is TRUE.}

\item{tol}{Correlation adjustment tolerance. When adjust.correlations = TRUE, correlations are adjusted so that the population correlation is within r='tol' of the target. Default = 0.005.}

\item{iter}{Max number of iterations to run the correlation adjustment for. Typically only a couple are needed. Default = 10.}

\item{N.adjustment}{Sample size to use when adjusting correlations. Default = 1000000.}

\item{r.x1.y.adjust}{Internal use only.}

\item{r.x2.y.adjust}{Internal use only.}

\item{r.x1.x2.adjust}{Internal use only.}

\item{r.x1x2.y.adjust}{Internal use only.}

\item{internal.adjust}{Internal use only.}

\item{skew.x1}{No longer supported.}

\item{skew.x2}{No longer supported.}

\item{skew.y}{No longer supported.}
}
\value{
A data frame containing variables 'x1', 'x2', 'y', and 'x1x2'. 'x1x2' is x1*x2. The correlations between these variables are drawn from the defined population-level values. Output variables are all z-scored (mean=0, sd=1).
}
\description{
Simulate a single data set with an interaction (y ~ x1 + x2 + x1*x2). All values other than 'N' are population-level effects - the values within any single simulated data set will vary around the defined values.
}
\examples{
dataset <- generate_interaction(N = 10,r.x1.y = 0,r.x2.y = .1,r.x1x2.y = -.2,r.x1.x2 = .3)
}
